/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.mojang.blaze3d.platform.InputConstants;
import com.storyanvil.cogwheel.client.devui.DevTab;
import com.storyanvil.cogwheel.network.devui.DevBoundRequest;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="storyanvil_cogwheel", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DevUI {
    protected static DevUI instance;
    private static final ResourceLocation ATLAS;
    protected Minecraft mc;
    protected Font mainFont;
    protected boolean fullscreen = false;
    protected int panelWidth;
    protected int panelLeft;
    protected int screenHeight;
    protected int screenWidth;
    protected Hover click = null;
    protected double tabScroll = 0.0;
    protected ArrayList<DevTab> tabs = new ArrayList();
    protected DevTab selected = null;
    private GuiGraphics g;
    public static final Lazy<KeyMapping> OPEN_DEVUI;

    public void renderLogic(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, int width, int height) {
        if (width != this.screenWidth || height != this.screenHeight) {
            this.resizeLogic(Minecraft.m_91087_(), width, height);
        }
        this.g = g;
        this.click = null;
        g.m_280509_(this.panelLeft, 0, this.screenWidth, this.screenHeight, -15987436);
        this.renderBtn(this.panelLeft, 0, 10, 10, 0, 0, 10, 10, this::fullscreenBtn, mouseX, mouseY);
        this.renderBtn(this.panelLeft + 10, 0, 10, 10, 10, 0, 10, 10, this::syncBtn, mouseX, mouseY);
        this.renderBtn(this.panelLeft + 20, 0, 10, 10, 20, 0, 10, 10, this::fileBtn, mouseX, mouseY);
        this.renderTabs(mouseX, mouseY, partialTick);
        this.g = null;
    }

    private void renderBtn(int x, int y, int w, int h, int ox, int oy, int sx, int sy, Consumer<Integer> click, int mX, int mY) {
        this.g.m_280411_(ATLAS, x, y, w, h, (float)ox, (float)oy, sx, sy, 256, 256);
        if (StoryUtils.isHovering(mX, mY, x, x + w, y, y + h)) {
            this.click = new Hover().withClick(click);
        }
    }

    private void renderTabs(int mX, int mY, float partialTick) {
        this.g.m_280509_(this.panelLeft, 10, this.screenWidth, 22, -14736844);
        boolean h = false;
        if (StoryUtils.isHovering(mX, mY, this.panelLeft, this.screenWidth, 12, 22)) {
            this.click = new Hover().withScroll(this::tabScroll);
            h = true;
        }
        this.g.m_280588_(this.panelLeft, 10, this.screenWidth, 22);
        int offestX = (int)this.tabScroll;
        Objects.requireNonNull(this.mainFont);
        int textY = 20 - 9;
        for (int i = 0; i < this.tabs.size(); ++i) {
            DevTab tab = this.tabs.get(i);
            boolean isSelected = tab == DevUI.instance.selected;
            int left = this.panelLeft + offestX;
            int w = this.mainFont.m_92895_(tab.getName()) + 4;
            int right = left + w;
            boolean isHovered = h && mX >= left && mX <= right;
            this.g.m_280509_(left, 10, right, 22, -15987436);
            if (isSelected) {
                this.g.m_280509_(left, 21, right, 22, -14468940);
            }
            if (isHovered) {
                this.click.withClick(I -> {
                    if (I == 1) {
                        if (tab.closeRequest()) {
                            this.tabs.remove(tab);
                            if (tab == this.selected) {
                                this.selected = this.tabs.isEmpty() ? null : this.tabs.get(0);
                            }
                        }
                    } else if (I == 0) {
                        this.selected = tab;
                    }
                });
            }
            this.g.m_280056_(this.mainFont, tab.getName(), left + 2, textY, (isSelected || isHovered ? ChatFormatting.WHITE : ChatFormatting.GRAY).m_126665_().intValue(), false);
            offestX += right - left;
        }
        this.g.m_280618_();
        this.g.m_280588_(this.panelLeft, 23, this.screenWidth, this.screenHeight);
        if (this.selected != null) {
            this.selected.render(this.g, mX, mY, partialTick, this.panelLeft, 23, this.screenWidth, this.screenHeight);
        }
        this.g.m_280618_();
    }

    public void resizeLogic(@NotNull Minecraft minecraft, int width, int height) {
        this.mc = minecraft;
        this.mainFont = minecraft.f_91062_;
        this.screenHeight = height;
        this.screenWidth = width;
        if (this.fullscreen) {
            this.panelLeft = 0;
            this.panelWidth = this.screenWidth;
        } else {
            this.panelWidth = this.panelLeft = width / 2;
        }
    }

    private void fullscreenBtn(int btn) {
        this.fullscreen = !this.fullscreen;
        this.screenWidth = -1;
    }

    private void syncBtn(int btn) {
        CogwheelPacketHandler.DELTA_BRIDGE.sendToServer((Object)new DevBoundRequest("full"));
    }

    private void fileBtn(int btn) {
    }

    private void tabScroll(double delta) {
        this.tabScroll += delta * 5.0;
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_DEVUI.get());
    }

    public boolean mouseClicked(int button) {
        if (this.click != null) {
            this.click.click.accept(button);
            return true;
        }
        return false;
    }

    public void reInit() {
        this.click = null;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.click != null) {
            this.click.scroll.accept(delta);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        return this.selected.keyPressed(key, scancode, mods);
    }

    static {
        ATLAS = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"textures/gui/devui.png");
        OPEN_DEVUI = Lazy.of(() -> new KeyMapping("ui.storyanvil_cogwheel.dev_ui", InputConstants.Type.KEYSYM, 96, "ui.storyanvil_cogwheel"));
    }

    public static class Hover {
        public Consumer<Integer> click = i -> {};
        public Consumer<Double> scroll = i -> {};

        public Hover withClick(Consumer<Integer> click) {
            this.click = click;
            return this;
        }

        public Hover withScroll(Consumer<Double> scroll) {
            this.scroll = scroll;
            return this;
        }
    }
}

