/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class CameraPos {
    private Vec3 pos;
    private float rotY;
    private float rotX;

    public CameraPos(Vec3 pos, float rotY, float rotX) {
        this.pos = pos;
        this.rotY = rotY;
        this.rotX = rotX;
    }

    public CameraPos() {
        this.pos = new Vec3(0.0, 0.0, 0.0);
        this.rotY = 0.0f;
        this.rotX = 0.0f;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    public float getRotY() {
        return this.rotY;
    }

    public void setRotY(float rotY) {
        this.rotY = rotY;
    }

    public float getRotX() {
        return this.rotX;
    }

    public void setRotX(float rotX) {
        this.rotX = rotX;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.pos.f_82479_);
        buf.writeDouble(this.pos.f_82480_);
        buf.writeDouble(this.pos.f_82481_);
        buf.writeFloat(this.rotX);
        buf.writeFloat(this.rotY);
    }

    public static CameraPos decode(FriendlyByteBuf buf) {
        CameraPos pos = new CameraPos();
        pos.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        pos.rotX = buf.readFloat();
        pos.rotY = buf.readFloat();
        return pos;
    }

    public String toString() {
        return "CameraPos{pos=" + String.valueOf(this.pos) + ", rotY=" + this.rotY + ", rotX=" + this.rotX + "}";
    }
}

