/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.entity;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.DialogTarget;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryActionQueue;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryChatter;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryModel;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNameHolder;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNavigator;
import com.storyanvil.cogwheel.infrastructure.abilities.StorySkinHolder;
import com.storyanvil.cogwheel.infrastructure.actions.AnimationAction;
import com.storyanvil.cogwheel.infrastructure.actions.PathfindAction;
import com.storyanvil.cogwheel.infrastructure.actions.WaitForLabelAction;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NPC
extends Animal
implements StoryActionQueue<NPC>,
StoryChatter,
StoryNameHolder,
StorySkinHolder,
StoryNavigator,
ObjectMonitor.IMonitored,
CogPropertyManager,
StoryAnimator,
GeoEntity,
StoryModel,
DialogTarget {
    private static final ObjectMonitor<NPC> MONITOR = new ObjectMonitor();
    private final Queue<StoryAction<? extends NPC>> actionQueue = new ArrayDeque<StoryAction<? extends NPC>>();
    private StoryAction current;
    private CogEntity me;
    private static final EntityDataAccessor<String> SKIN = SynchedEntityData.m_135353_(NPC.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(NPC.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> MODEL = SynchedEntityData.m_135353_(NPC.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EasyPropManager MANAGER = new EasyPropManager("npc", NPC::registerProps);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.npc.walk");
    private RawAnimation customAnimation = null;

    public NPC(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        MONITOR.register(this);
        if (!pLevel.f_46443_) {
            this.me = new CogEntity((Entity)this);
            this.setSkin(DataStorage.getString((Entity)this, "skin", "test"));
            this.setCustomName(DataStorage.getString((Entity)this, "name", "NPC"));
            this.setStoryModelID(DataStorage.getString((Entity)this, "model", "npc"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.current != null) {
                if (this.current.freeToGo(this)) {
                    this.current = null;
                }
            } else {
                if (this.actionQueue.isEmpty()) {
                    return;
                }
                this.current = this.actionQueue.remove();
                this.current.proceed(this);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    @Nullable
    public Component m_7770_() {
        return Component.m_237113_((String)((String)this.f_19804_.m_135370_(NAME)));
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getCogName() {
        return (String)this.f_19804_.m_135370_(NAME);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setCogName(String name) {
        this.f_19804_.m_276349_(NAME, (Object)name, true);
        if (!this.m_9236_().f_46443_) {
            DataStorage.setString((Entity)this, "name", name);
        }
    }

    @Api.Stable(since="2.0.0")
    public void m_6593_(@Nullable Component pName) {
        this.f_19804_.m_276349_(NAME, (Object)(pName == null ? "NPC" : pName.getString()), true);
    }

    @Api.Stable(since="2.0.0")
    public void setCustomName(@Nullable String pName) {
        this.f_19804_.m_276349_(NAME, (Object)(pName == null ? "NPC" : pName), true);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    @ApiStatus.Internal
    @Api.Internal
    protected void m_8099_() {
    }

    @Nullable
    @Api.Internal
    @ApiStatus.Internal
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN, (Object)"test");
        this.f_19804_.m_135372_(NAME, (Object)"NPC");
        this.f_19804_.m_135372_(MODEL, (Object)"npc");
    }

    public void m_6043_() {
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getSkin() {
        return (String)this.f_19804_.m_135370_(SKIN);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setSkin(String skin) {
        this.f_19804_.m_276349_(SKIN, (Object)skin, true);
        if (!this.m_9236_().f_46443_) {
            DataStorage.setString((Entity)this, "skin", skin);
        }
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void chat(String text) {
        if (!this.m_9236_().f_46443_) {
            MutableComponent c = Component.m_237113_((String)("[" + this.getCogName() + "] " + text));
            for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
                player.m_213846_((Component)c);
            }
        }
    }

    @Override
    @Api.Stable(since="2.0.0")
    public <R> void addStoryAction(StoryAction<R> action) {
        this.actionQueue.add(action);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void reportState(StringBuilder sb) {
        for (StoryAction storyAction : this.actionQueue) {
            sb.append(storyAction.toString());
        }
        sb.append(">").append(this.current.toString());
        sb.append(" | ").append(this);
    }

    private static void registerProps(EasyPropManager manager) {
        manager.reg("setName", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setCogName(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getName", (name, args, script, o) -> new CogString(((NPC)o).getCogName()));
        manager.reg("setSkin", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setSkin(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getSkin", (name, args, script, o) -> new CogString(((NPC)o).getSkin()));
        manager.reg("setModel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setStoryModelID(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getModel", (name, args, script, o) -> new CogString(((NPC)o).getStoryModelID()));
        manager.reg("chat", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.chat(args.get(0).convertToString());
                }
            });
        });
        manager.reg("pathfind", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new PathfindAction(new BlockPos(args.requireInt(0), args.requireInt(1), args.requireInt(2))));
        });
        manager.reg("waitForLabel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            if (args.size() == 1) {
                return npc.addChained(new WaitForLabelAction(args.getString(0)));
            }
            return npc.addChained(new WaitForLabelAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("animation", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new AnimationAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("dialogChoices", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            final Component[] components = new Component[args.size()];
            for (int i = 0; i < components.length; ++i) {
                int finalI = i;
                components[i] = Component.m_237113_((String)("[" + (i + 1) + "] ")).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)args.getString(i)).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/@storyclient dialog " + finalI + " " + dialogID)).m_131140_(ChatFormatting.WHITE)));
            }
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> StoryUtils.sendGlobalMessage((ServerLevel)event.level, components));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        script.put(variable, new CogInteger((int)response));
                        script.lineDispatcher();
                    }));
                }
            });
        });
        manager.reg("dialogBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = DialogBound.tell(args.getString(0), npc.getCogName(), args.getString(1));
            npc.addStoryAction(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)bound);
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(e -> {
                        script.put(variable, CogPropertyManager.nullManager);
                        CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)DialogBound.close());
                        if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(npc.getAnimatorID(), "null"));
                        }
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }, args.requireInt(2));
                }
            });
        });
        manager.reg("dialogNonBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = DialogBound.tell(args.getString(0), npc.getCogName(), args.getString(1));
            npc.addStoryAction(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)bound);
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }

                @Override
                public void onEnding() {
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)DialogBound.close());
                    if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                        CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(npc.getAnimatorID(), "null"));
                    }
                }
            });
            return null;
        });
        manager.reg("dialogChoiceUI", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            int optionsLength = args.size() - 1;
            String[] options = new String[optionsLength - 1];
            for (int i = 0; i < optionsLength - 1; ++i) {
                options[i] = args.getString(i + 1);
            }
            final DialogChoiceBound bound = DialogChoiceBound.choice(dialogID, args.getString(0), options, npc.getCogName(), args.getString(optionsLength));
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)bound));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)DialogChoiceBound.close()));
                        script.put(variable, new CogInteger((int)response));
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }));
                }
            });
        });
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean hasOwnProperty(String name) {
        if (this.me.hasOwnProperty(name)) {
            return true;
        }
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Api.Stable(since="2.0.0")
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        if (this.me.hasOwnProperty(name)) {
            return this.me.getProperty(name, args, script);
        }
        return MANAGER.get(name).handle(name, args, script, this.me());
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean equalsTo(CogPropertyManager o) {
        return false;
    }

    @Contract(value=" -> this", pure=true)
    private NPC me() {
        return this;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walking", this::walkAnim)});
    }

    protected <E extends NPC> PlayState walkAnim(AnimationState<E> event) {
        if (this.customAnimation != null) {
            return event.setAndContinue(this.customAnimation);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public String getAnimatorID() {
        return this.m_20149_();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void pushAnimation(String name) {
        if (name.equals("null")) {
            this.customAnimation = null;
            return;
        }
        this.customAnimation = RawAnimation.begin().thenLoop(name);
    }

    @Override
    public String getStoryModelID() {
        return (String)this.f_19804_.m_135370_(MODEL);
    }

    @Override
    public void setStoryModelID(String id) {
        this.f_19804_.m_276349_(MODEL, (Object)id, true);
        if (!this.m_9236_().f_46443_) {
            DataStorage.setString((Entity)this, "model", id);
        }
    }

    @Override
    public void d$say(String text, String texture, int ticks, final Runnable trigger) {
        final DialogBound bound = DialogBound.tell(text, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Ticking<NPC>(ticks){

            @Override
            public void proceed(NPC myself) {
                CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)bound);
                CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
            }

            @Override
            public void onEnding() {
                CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)DialogBound.close());
                if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)new AnimationBound(NPC.this.getAnimatorID(), "null"));
                }
                CogwheelExecutor.schedule(trigger);
            }
        });
    }

    @Override
    public void d$ask(String text, String texture, List<String> options, Consumer<Integer> acceptor) {
        String dialogID = UUID.randomUUID().toString();
        final DialogChoiceBound bound = DialogChoiceBound.choice(dialogID, text, options, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Instant<NPC>(){

            @Override
            public void proceed(NPC myself) {
                CogwheelExecutor.scheduleTickEvent(event -> CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)bound));
            }
        });
        CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)DialogChoiceBound.close()));
            acceptor.accept((Integer)response);
        }));
    }

    @Override
    public String d$name() {
        return this.getCogName();
    }
}

