/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.network.mc.CogwheelClientPacketHandler;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AnimationBound {
    @NotNull
    private String animatorID;
    @NotNull
    private String animation;

    @Contract(pure=true)
    public AnimationBound() {
        this.animatorID = "";
        this.animation = "";
    }

    @NotNull
    public String getAnimatorID() {
        return this.animatorID;
    }

    @NotNull
    public String getAnimation() {
        return this.animation;
    }

    @Contract(pure=true)
    public AnimationBound(@NotNull String animatorID, @NotNull String animation) {
        this.animatorID = animatorID;
        this.animation = animation;
        if (!CogwheelConfig.isNpcTalkingAnimationEnabled() && animation.equals("animation.npc.talk")) {
            this.animation = "<ignore>";
        }
    }

    public void encode(@NotNull FriendlyByteBuf friendlyByteBuf) {
        StoryUtils.encodeString(friendlyByteBuf, this.animatorID);
        StoryUtils.encodeString(friendlyByteBuf, this.animation);
    }

    @NotNull
    public static AnimationBound decode(FriendlyByteBuf friendlyByteBuf) {
        AnimationBound bound = new AnimationBound();
        bound.animatorID = StoryUtils.decodeString(friendlyByteBuf);
        bound.animation = StoryUtils.decodeString(friendlyByteBuf);
        return bound;
    }

    public void handle(@NotNull Supplier<NetworkEvent.Context> ctx) {
        if (!this.animation.equals("<ignore>")) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
        }
        ctx.get().setPacketHandled(true);
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
        return () -> this.lambda$handle$0((Supplier)ctx);
    }

    private /* synthetic */ void lambda$handle$0(Supplier ctx) {
        CogwheelClientPacketHandler.animationBound(this, ctx);
    }
}

