/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.network.mc.CogwheelClientPacketHandler;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DialogBound {
    private boolean close = false;
    private String request = "";
    private String npcName = "";
    private String texture = "";

    public static DialogBound close() {
        DialogBound bound = new DialogBound();
        bound.close = true;
        return bound;
    }

    public static DialogBound tell(String request, String npcName, String texture) {
        DialogBound bound = new DialogBound();
        bound.request = request;
        bound.npcName = npcName;
        bound.texture = texture.toLowerCase().replace(' ', '_');
        return bound;
    }

    public boolean isClose() {
        return this.close;
    }

    public String getRequest() {
        return this.request;
    }

    public String getNpcName() {
        return this.npcName;
    }

    public String getTexture() {
        return this.texture;
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeBoolean(this.close);
        StoryUtils.encodeString(byteBuf, this.request);
        StoryUtils.encodeString(byteBuf, this.npcName);
        StoryUtils.encodeString(byteBuf, this.texture);
    }

    public static DialogBound decode(FriendlyByteBuf byteBuf) {
        DialogBound bound = new DialogBound();
        bound.close = byteBuf.readBoolean();
        bound.request = StoryUtils.decodeString(byteBuf);
        bound.npcName = StoryUtils.decodeString(byteBuf);
        bound.texture = StoryUtils.decodeString(byteBuf);
        return bound;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public String toString() {
        return "DialogBound{close=" + this.close + ", request='" + this.request + "'}";
    }

    private /* synthetic */ Callable lambda$handle$1(Supplier contextSupplier) {
        return () -> this.lambda$handle$0((Supplier)contextSupplier);
    }

    private /* synthetic */ Object lambda$handle$0(Supplier contextSupplier) throws Exception {
        return CogwheelClientPacketHandler.dialogBound(this, contextSupplier);
    }
}

