/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogInvoker;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@Api.Internal
@ApiStatus.Internal
public class EasyPropManager {
    private static final HashMap<String, PropertyHandler> handlers = new HashMap();
    private String manager;
    private final Registrar registrar;

    @Contract(pure=true)
    @Api.Internal
    @ApiStatus.Internal
    public EasyPropManager(String manager, Registrar registrar) {
        this.manager = ">" + manager;
        this.registrar = registrar;
    }

    @Api.Internal
    @ApiStatus.Internal
    public boolean hasOwnProperty(String name) {
        if (this.manager.charAt(0) != '<') {
            this.manager = "<" + this.manager;
            this.reg("toString", (__, args, script, o) -> ((CogPropertyManager)o).convertToCogString());
            this.reg("equals", (__, args, script, o) -> CogBool.getInstance(((CogPropertyManager)o).equalsTo(args.get(0))));
            this.reg("asInvoker", (__, args, script, o) -> {
                CogPropertyManager m = (CogPropertyManager)o;
                return CogInvoker.genericInvoker(m, args.getString(0));
            });
            this.registrar.register(this);
        }
        return handlers.containsKey(this.manager + name);
    }

    @Api.Internal
    @ApiStatus.Internal
    public boolean hasOwnProperty(String name, Function<String, Boolean> alt) {
        return this.hasOwnProperty(name) || alt.apply(name) != false;
    }

    @Api.Internal
    @ApiStatus.Internal
    public PropertyHandler get(String name) {
        return handlers.get(this.manager + name);
    }

    @Api.Internal
    @ApiStatus.Internal
    public PropertyHandler get(String name, Function<String, PropertyHandler> alt) {
        PropertyHandler h = this.get(name);
        if (h != null) {
            return h;
        }
        return alt.apply(name);
    }

    @Api.Internal
    @ApiStatus.Internal
    public CogPropertyManager get(String name, ArgumentData args, DispatchedScript script, Object o) {
        PropertyHandler h = this.get(name);
        return h.handle(name, args, script, o);
    }

    @Api.Internal
    @ApiStatus.Internal
    public CogPropertyManager get(String name, ArgumentData args, DispatchedScript script, Object o, Supplier<CogPropertyManager> alt) {
        PropertyHandler h = this.get(name);
        if (h != null) {
            return h.handle(name, args, script, o);
        }
        return alt.get();
    }

    @Api.Internal
    @ApiStatus.Internal
    public void reg(String name, PropertyHandler handler) {
        handlers.put(this.manager + name, handler);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static interface Registrar {
        @Api.Internal
        @ApiStatus.Internal
        public void register(EasyPropManager var1);
    }
}

