/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.datagen;

import com.storyanvil.cogwheel.datagen.BlockStates;
import com.storyanvil.cogwheel.datagen.BlocksTags;
import com.storyanvil.cogwheel.datagen.ItemModels;
import com.storyanvil.cogwheel.datagen.ItemTags;
import com.storyanvil.cogwheel.datagen.LootTables;
import com.storyanvil.cogwheel.datagen.RecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storyanvil_cogwheel", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(@NotNull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)LootTables.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, existingFileHelper));
        BlocksTags blockTags = (BlocksTags)generator.addProvider(event.includeServer(), (DataProvider)new BlocksTags(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
    }
}

