/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.infrastructure.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class CogScriptDispatcher {
    public static void dispatch(String scriptName, CogScriptEnvironment environment) {
        CogwheelExecutor.schedule(() -> CogScriptDispatcher.dispatchUnsafe(scriptName, new ScriptStorage(), environment));
    }

    public static void dispatch(String scriptName, ScriptStorage storage, CogScriptEnvironment environment) {
        CogwheelExecutor.schedule(() -> CogScriptDispatcher.dispatchUnsafe(scriptName, storage, environment));
    }

    public static void dispatch(String scriptName, Consumer<DispatchedScript> s, CogScriptEnvironment environment) {
        CogwheelExecutor.schedule(() -> s.accept(CogScriptDispatcher.dispatchUnsafe(scriptName, new ScriptStorage(), environment)));
    }

    public static void dispatch(String scriptName, ScriptStorage storage, Consumer<DispatchedScript> s, CogScriptEnvironment environment) {
        CogwheelExecutor.schedule(() -> s.accept(CogScriptDispatcher.dispatchUnsafe(scriptName, storage, environment)));
    }

    @Nullable
    public static DispatchedScript dispatchUnsafe(String scriptName, ScriptStorage storage, CogScriptEnvironment environment) {
        File script = new File(Minecraft.m_91087_().f_91069_, "config/" + scriptName);
        return CogScriptDispatcher.dispatchUnsafe(script, storage, environment);
    }

    @Nullable
    public static DispatchedScript dispatchUnsafe(File script, ScriptStorage storage, CogScriptEnvironment environment) {
        String scriptName = script.getName();
        if (!script.exists()) {
            CogwheelExecutor.log.error("Script {} does not exist. Dispatch ignored!", (Object)script);
            return null;
        }
        if (scriptName.endsWith(".sa")) {
            CogwheelExecutor.log.info("Script: {} dispatched", (Object)scriptName);
            return CogScriptDispatcher.readAndDispatch(scriptName, storage, environment, script);
        }
        CogwheelExecutor.log.error("Script {} does not end with any known extension (known extensions are: \".sa\"). Dispatch ignored!", (Object)script);
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static DispatchedScript readAndDispatch(String scriptName, ScriptStorage storage, CogScriptEnvironment environment, File script) {
        try (FileReader fr = new FileReader(script);){
            Scanner sc = new Scanner(fr);
            try {
                ArrayList<String> lines = new ArrayList<String>();
                while (sc.hasNextLine()) {
                    lines.add(sc.nextLine().trim());
                }
                DispatchedScript s = new DispatchedScript(lines, storage, environment);
                CogwheelExecutor.schedule(s.setScriptName(scriptName)::lineDispatcher);
                DispatchedScript dispatchedScript = s;
                sc.close();
                return dispatchedScript;
            }
            catch (Throwable throwable) {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CogwheelExecutor.log.error("Script dispatch failed while file reading", (Throwable)e);
            return null;
        }
    }
}

