/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import com.storyanvil.cogwheel.util.ScriptLineHandler;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DispatchedScript
implements ObjectMonitor.IMonitored {
    @ApiStatus.Internal
    @Api.Internal
    public static final ObjectMonitor<DispatchedScript> MONITOR = new ObjectMonitor();
    private final ArrayList<String> linesToExecute;
    private ScriptStorage storage;
    private HashMap<Integer, ScriptLineHandler> additionalLineHandlers;
    private String scriptName = "unknown-script";
    private CogScriptEnvironment environment;
    private boolean doNotRemoveLines = false;
    private int lineSkipped = 0;
    private int executionLine = 0;

    public DispatchedScript(ArrayList<String> linesToExecute, CogScriptEnvironment environment) {
        MONITOR.register(this);
        this.linesToExecute = linesToExecute;
        this.storage = new ScriptStorage();
        this.environment = environment;
        this.additionalLineHandlers = new HashMap();
        CogwheelRegistries.putDefaults(this.storage, this);
    }

    public DispatchedScript(ArrayList<String> linesToExecute, ScriptStorage storage, CogScriptEnvironment environment) {
        MONITOR.register(this);
        this.linesToExecute = linesToExecute;
        this.storage = storage;
        this.environment = environment;
        this.additionalLineHandlers = new HashMap();
        CogwheelRegistries.putDefaults(this.storage, this);
    }

    @ApiStatus.Internal
    public DispatchedScript setScriptName(String scriptName) {
        this.scriptName = scriptName;
        return this;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    private boolean executeLine(@NotNull String line) {
        for (ScriptLineHandler handler : CogwheelRegistries.getLineHandlers()) {
            try {
                byte result = handler.handle(line, this);
                if (result == ScriptLineHandler.ignore()) continue;
                return result == ScriptLineHandler.continueReading();
            }
            catch (Throwable e) {
                CogwheelExecutor.log.warn("{}: LineHandler {} failed with exception. Line: \"{}\"", new Object[]{this.getScriptName(), handler.getResourceLocation(), line, e});
            }
        }
        CogwheelExecutor.log.warn("{}: None of LineHandlers could handle line: \"{}\". Skipping the line", (Object)this.getScriptName(), (Object)line);
        return true;
    }

    public void lineDispatcher() {
        if (!Thread.currentThread().getName().contains("cogwheel-executor")) {
            RuntimeException e = new RuntimeException("Line dispatcher can only be run in cogwheel executor thread");
            e.printStackTrace();
            CogwheelExecutor.log.error("[!CRITICAL!] LINE DISPATCHER WAS CALLED FROM NON-EXECUTOR THREAD! THIS WILL CAUSE MEMORY LEAKS AND PREVENT SCRIPTS FOR PROPER EXECUTION! THIS CALL WAS DISMISSED, PROBABLY CAUSING A MEMORY LEAK!");
            throw e;
        }
        this.lineDispatcherInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lineDispatcherInternal() {
        try {
            while (!this.linesToExecute.isEmpty()) {
                String line;
                if (this.doNotRemoveLines) {
                    line = this.linesToExecute.get(this.lineSkipped);
                    ++this.lineSkipped;
                } else {
                    line = this.linesToExecute.get(0).trim();
                    this.linesToExecute.remove(0);
                }
                ++this.executionLine;
                if (!this.executeLine(line)) {
                    return;
                }
                if (!this.additionalLineHandlers.containsKey(this.executionLine)) continue;
                try {
                    byte res = this.additionalLineHandlers.get(this.executionLine).handle(line, this);
                    this.additionalLineHandlers.remove(this.executionLine);
                    if (res != ScriptLineHandler.blocking()) continue;
                    return;
                }
                catch (Throwable e) {
                    CogwheelExecutor.log.warn("{}: Planned LineHandler {} failed with exception. Line: \"{}\"", new Object[]{this.getScriptName(), this.additionalLineHandlers.get(this.executionLine).getResourceLocation(), line, e});
                }
            }
            return;
        }
        catch (Throwable e) {
            RuntimeException a = new RuntimeException("Exception in lineDispatcher reflected:", e);
            CogwheelExecutor.log.error("FATAL LINE DISPATCHER FAILURE!", (Throwable)a);
            throw a;
        }
    }

    public void stopLineUnloading() {
        this.doNotRemoveLines = true;
        this.lineSkipped = 0;
    }

    public void continueUnloadingLines() {
        this.doNotRemoveLines = false;
    }

    public void removeUnloadedLines() {
        for (int i = 0; i < this.lineSkipped; ++i) {
            this.removeLine(0);
        }
    }

    public void plantHandler(ScriptLineHandler handler, int lineAhead) {
        this.additionalLineHandlers.put(this.executionLine + lineAhead, handler);
    }

    public void put(String key, CogPropertyManager o) {
        if (o == null) {
            return;
        }
        if (key == null) {
            return;
        }
        this.storage.put(key, o);
    }

    @Nullable
    public CogPropertyManager get(String key) {
        return (CogPropertyManager)this.storage.get(key);
    }

    public boolean hasKey(String key) {
        return this.storage.containsKey(key);
    }

    @Override
    public void reportState(@NotNull StringBuilder sb) {
        sb.append(this.scriptName).append(">");
        for (String line : this.linesToExecute) {
            sb.append('\"').append(line).append("\" ");
        }
    }

    public String pullLine() {
        if (this.linesToExecute.isEmpty()) {
            return null;
        }
        String l = this.linesToExecute.get(0);
        this.linesToExecute.remove(0);
        return l;
    }

    public void removeLine() {
        if (this.linesToExecute.isEmpty()) {
            return;
        }
        this.linesToExecute.remove(0);
    }

    public void removeLine(int line) {
        this.linesToExecute.remove(line);
    }

    public String peekLine() {
        if (this.linesToExecute.isEmpty()) {
            return null;
        }
        return this.linesToExecute.get(0);
    }

    public String peekLine(int line) {
        if (line >= this.linesToExecute.size()) {
            return null;
        }
        return this.linesToExecute.get(line);
    }

    public void defuseLine(int line) {
        this.linesToExecute.set(line, "");
    }

    public int linesLeft() {
        return this.linesToExecute.size();
    }

    public ScriptStorage getStorage() {
        return this.storage;
    }

    public CogScriptEnvironment getEnvironment() {
        return this.environment;
    }

    public void haltExecution() {
        CogwheelExecutor.log.info("Script {} is being forcefully stopped!", (Object)this.getScriptName());
        this.linesToExecute.clear();
        this.environment = null;
        this.storage.clear();
        this.storage = null;
    }

    public String toString() {
        return "DispatchedScript{scriptName='" + this.scriptName + "', environment=" + String.valueOf(this.environment) + "}";
    }

    public void clearLines() {
        this.linesToExecute.clear();
    }
}

