/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogEntity
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("entity", CogEntity::registerProps);
    private final WeakReference<Entity> e;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("getEntityType", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(((ResourceKey)ForgeRegistries.ENTITY_TYPES.getResourceKey((Object)Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_6095_()).get()).m_135782_().toString());
        });
        manager.reg("getUUID", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20149_());
        });
        manager.reg("toEntity", (name, args, script, o) -> (CogEntity)o);
        manager.reg("teleport", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20324_(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            return e;
        });
        manager.reg("turn", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19884_(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1));
            return e;
        });
        manager.reg("teleport2", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20324_(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19884_(args.requireDoubleOrInt(3), args.requireDoubleOrInt(4));
            return e;
        });
        manager.reg("getX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20185_());
        });
        manager.reg("getY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20186_());
        });
        manager.reg("getZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_20189_());
        });
        manager.reg("getBlockX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_146903_());
        });
        manager.reg("getBlockY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_146904_());
        });
        manager.reg("getBlockZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_146907_());
        });
        manager.reg("kill", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_6074_();
            e.e.clear();
            return null;
        });
        manager.reg("hasTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19880_().contains(args.getString(0)));
        });
        manager.reg("addTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19880_().add(args.getString(0)));
        });
        manager.reg("removeTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19880_().remove(args.getString(0)));
        });
        manager.reg("getTags", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogArray.convertInstance(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded").m_19880_());
        });
        manager.reg("putInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setInt(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), args.requireInt(1));
            return e;
        });
        manager.reg("getInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(DataStorage.getInt(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), 0));
        });
        manager.reg("putString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), args.getString(1));
            return e;
        });
        manager.reg("getString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(DataStorage.getString(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), ""));
        });
        manager.reg("putBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setBoolean(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), args.requireBoolean(1));
            return e;
        });
        manager.reg("getBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(DataStorage.getBoolean(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), false));
        });
        manager.reg("putLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), String.valueOf(args.requireLong(1)));
            return e;
        });
        manager.reg("getLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogLong(DataStorage.getString(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), args.getString(0), "0"));
        });
        manager.reg("getDisplayName", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(Objects.requireNonNull(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), "entity got unloaded").m_5446_().getString());
        });
    }

    @Api.Experimental(since="2.0.0")
    public CogEntity(WeakReference<Entity> entity) {
        this.e = entity;
    }

    @Api.Stable(since="2.0.0")
    public CogEntity(Entity entity) {
        this(new WeakReference<Entity>(entity));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        if (o instanceof CogEntity) {
            CogEntity other = (CogEntity)o;
            return this.e.get() == other.e.get();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.e);
    }
}

