/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.util.CogExpressionFailure;
import com.storyanvil.cogwheel.util.EasyPropManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogManifest
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("manifest", CogManifest::registerProps);
    private static CogManifest instance = null;

    @Api.Experimental(since="2.0.0")
    public static CogManifest getInstance() {
        if (instance == null) {
            instance = new CogManifest();
        }
        return instance;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("subscribeEvent", (name, args, script, o) -> {
            script.getEnvironment().subscribeForEvent(ResourceLocation.parse((String)args.getString(0)), args.getString(1));
            return null;
        });
        manager.reg("unsubscribeEvent", (name, args, script, o) -> {
            script.getEnvironment().unsubscribeFromEvent(ResourceLocation.parse((String)args.getString(0)), args.getString(1));
            return null;
        });
        manager.reg("clearEvent", (name, args, script, o) -> {
            script.getEnvironment().unsubscribeAllFromEvent(ResourceLocation.parse((String)args.getString(0)));
            return null;
        });
        manager.reg("requireLibrary", (name, args, script, o) -> {
            CogScriptEnvironment.LibraryEnvironment env = CogScriptEnvironment.getLibEnvironment(args.getString(0));
            if (env == null) {
                script.haltExecution();
                throw new CogExpressionFailure("Library \"" + args.getString(0) + "\" required by " + script.getEnvironment().getUniqueIdentifier() + " environment but it does not present!");
            }
            return null;
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o == this;
    }
}

