/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.env;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.CogScriptDispatcher;
import com.storyanvil.cogwheel.infrastructure.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.module.CogModule;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.WeakList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CogScriptEnvironment {
    private final HashMap<ResourceLocation, List<String>> eventSubscribers = new HashMap();
    private final long creationTime = System.currentTimeMillis();

    @Contract(pure=true)
    public CogScriptEnvironment() {
    }

    @Api.Stable(since="2.0.0")
    public static LibraryEnvironment getLibEnvironment(String string) {
        return CogwheelExecutor.getLibraryEnvironment(string);
    }

    @Api.Stable(since="2.0.0")
    public void dispatchEvent(ResourceLocation event, ScriptStorage storage) {
        if (this.eventSubscribers.containsKey(event)) {
            List<String> subscribedScripts = this.eventSubscribers.get(event);
            for (String script : subscribedScripts) {
                this.dispatchScript(script, storage);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    public void subscribeForEvent(ResourceLocation event, String scriptName) {
        if (!this.eventSubscribers.containsKey(event)) {
            this.eventSubscribers.put(event, new ArrayList());
        }
        this.eventSubscribers.get(event).add(scriptName);
    }

    @Api.Stable(since="2.0.0")
    public void unsubscribeFromEvent(ResourceLocation event, String scriptName) {
        if (!this.eventSubscribers.containsKey(event)) {
            this.eventSubscribers.put(event, new ArrayList());
            return;
        }
        this.eventSubscribers.get(event).remove(scriptName);
    }

    @Api.Stable(since="2.0.0")
    public void unsubscribeAllFromEvent(ResourceLocation event) {
        this.eventSubscribers.remove(event);
    }

    @Api.Stable(since="2.0.0")
    public static void dispatchEventGlobal(ResourceLocation event, ScriptStorage storage) {
        CogwheelExecutor.getDefaultEnvironment().dispatchEvent(event, storage);
        for (CogScriptEnvironment cogScriptEnvironment : CogwheelExecutor.getLibraryEnvironments()) {
            cogScriptEnvironment.dispatchEvent(event, storage);
        }
    }

    @ApiStatus.Internal
    public void dispose() {
        CogwheelExecutor.log.info("Environment {} is disposing...", (Object)this.getUniqueIdentifier());
        WeakList<DispatchedScript> scripts = DispatchedScript.MONITOR.getObjects();
        for (int i = 0; i < scripts.size(); ++i) {
            DispatchedScript script = scripts.get(i);
            if (script == null) {
                scripts.remove(i);
                --i;
                continue;
            }
            if (script.getEnvironment() != this) continue;
            script.haltExecution();
        }
    }

    public abstract void dispatchScript(String var1);

    public abstract void dispatchScript(String var1, ScriptStorage var2);

    public abstract String getScript(String var1);

    @Api.Internal
    @ApiStatus.Internal
    public static void dispatchScriptGlobal(String rl) {
        ResourceLocation loc = ResourceLocation.parse((String)rl);
        CogScriptEnvironment.dispatchScriptGlobal(loc);
    }

    @Api.Experimental(since="2.0.0")
    public static void dispatchScriptGlobal(ResourceLocation loc) {
        CogScriptEnvironment environment = null;
        environment = CogScriptEnvironment.getEnvironment(loc);
        if (environment == null) {
            throw new RuntimeException("Dispatch Failure! No environment found");
        }
        environment.dispatchScript(loc.m_135815_());
    }

    public static CogScriptEnvironment getEnvironment(ResourceLocation loc) {
        CogScriptEnvironment environment = loc.m_135827_().equals("def") || loc.m_135827_().equals("minecraft") ? CogwheelExecutor.getDefaultEnvironment() : (loc.m_135827_().equals("wrld") ? CogwheelExecutor.getWorldEnvironment() : CogwheelExecutor.getLibraryEnvironment(loc.m_135827_()));
        return environment;
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void dispatchScriptGlobal(String rl, ScriptStorage storage) {
        ResourceLocation loc = ResourceLocation.parse((String)rl);
        CogScriptEnvironment.dispatchScriptGlobal(loc, storage);
    }

    @Api.Experimental(since="2.0.0")
    public static void dispatchScriptGlobal(ResourceLocation loc, ScriptStorage storage) {
        CogScriptEnvironment environment = CogScriptEnvironment.getEnvironment(loc);
        if (environment == null) {
            throw new RuntimeException("Dispatch Failure! No environment found");
        }
        environment.dispatchScript(loc.m_135815_(), storage);
    }

    @NotNull
    public EnvironmentData getData() {
        return (EnvironmentData)EventBus.getStoryLevel().getLevel().m_8895_().m_164861_(EnvironmentData::new, EnvironmentData::new, "cg" + this.getUniqueIdentifier());
    }

    public abstract String getUniqueIdentifier();

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "CogScriptEnvironment{name=" + this.getUniqueIdentifier() + "}";
    }

    public static class LibraryEnvironment
    extends CogScriptEnvironment {
        private final String name;

        public LibraryEnvironment(String name) {
            this.name = name;
            CogwheelExecutor.log.info("Library Environment {} initialized!", (Object)this.getUniqueIdentifier());
        }

        @ApiStatus.Internal
        public boolean init(File dotCog) {
            try {
                File manifest = new File(dotCog, "manifest.json");
                JsonObject obj = JsonParser.parseReader((Reader)new FileReader(manifest)).getAsJsonObject();
                String name = obj.get("name").getAsJsonPrimitive().getAsString();
                if (!name.equals(this.name)) {
                    throw new IllegalStateException("Library names does not match!");
                }
            }
            catch (FileNotFoundException | IllegalStateException e) {
                CogwheelExecutor.log.info("Library \"{}\" does not have manifest.json or its manifest.json is invalid. Library won't be loaded", (Object)this.name);
                CogwheelExecutor.log.info("Exception for " + this.name, (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public void dispatchScript(String name) {
            CogScriptDispatcher.dispatch("cog-libs/.cog/" + this.name + "/" + name, this);
        }

        @Override
        public void dispatchScript(String name, ScriptStorage storage) {
            CogScriptDispatcher.dispatch("cog-libs/.cog/" + this.name + "/" + name, storage, (CogScriptEnvironment)this);
        }

        @Override
        public String getScript(String name) {
            return "cog-libs/.cog/" + this.name + "/" + name;
        }

        @Override
        public String getUniqueIdentifier() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class DefaultEnvironment
    extends CogScriptEnvironment {
        private final HashMap<String, Consumer<Integer>> dialogs;
        private final HashMap<ResourceLocation, CogModule> moduleMap = new HashMap();

        public DefaultEnvironment() {
            this.dialogs = new HashMap();
            CogwheelExecutor.log.info("Default Environment {} initialized!", (Object)this.getUniqueIdentifier());
        }

        @Override
        public void dispatchScript(String name) {
            CogScriptDispatcher.dispatch("cog/" + name, this);
        }

        @Override
        public void dispatchScript(String name, ScriptStorage storage) {
            CogScriptDispatcher.dispatch("cog/" + name, storage, (CogScriptEnvironment)this);
        }

        @Override
        public String getScript(String name) {
            return "cog/" + name;
        }

        @Override
        public String getUniqueIdentifier() {
            return "default_environment";
        }

        public void registerDialog(String id, Consumer<Integer> callback) {
            this.dialogs.put(id, callback);
        }

        public HashMap<String, Consumer<Integer>> getDialogs() {
            return this.dialogs;
        }

        public void putModule(ResourceLocation loc, CogModule module) {
            this.moduleMap.put(loc, module);
        }

        public CogModule getModule(ResourceLocation loc) {
            return this.moduleMap.get(loc);
        }

        public ResourceLocation getModuleLoc(CogScriptEnvironment env, String script) {
            return ResourceLocation.fromNamespaceAndPath((String)env.getUniqueIdentifier(), (String)script);
        }
    }

    public static class WorldEnvironment
    extends CogScriptEnvironment {
        @Override
        public void dispatchScript(String name) {
        }

        @Override
        public void dispatchScript(String name, ScriptStorage storage) {
        }

        @Override
        public String getScript(String name) {
            return "";
        }

        @Override
        public String getUniqueIdentifier() {
            return "world_environment";
        }
    }

    public static class EnvironmentData
    extends SavedData {
        private final HashMap<String, CogPrimalType> data = new HashMap();

        private EnvironmentData() {
        }

        private EnvironmentData(@NotNull CompoundTag tag) {
            for (String key : tag.m_128431_()) {
                CompoundTag t = (CompoundTag)tag.m_128423_(key);
                if (t == null) {
                    throw new RuntimeException("Failed to parse EnvironmentData for " + String.valueOf(tag));
                }
                byte type = t.m_128445_("t");
                CogPrimalType v = null;
                switch (type) {
                    case 38: {
                        v = CogBool.getInstance(t.m_128471_("v"));
                        break;
                    }
                    case 39: {
                        v = new CogInteger(t.m_128451_("v"));
                        break;
                    }
                    case 40: {
                        v = new CogDouble(t.m_128459_("v"));
                        break;
                    }
                    case 41: {
                        v = new CogString(t.m_128461_("v"));
                    }
                }
                this.data.put(key, v);
            }
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag tag) {
            for (Map.Entry<String, CogPrimalType> entry : this.data.entrySet()) {
                CompoundTag t = new CompoundTag();
                t.m_128344_("t", entry.getValue().getPrimalID());
                entry.getValue().putPrimal(t, "v");
                tag.m_128365_(entry.getKey(), (Tag)t);
            }
            return tag;
        }

        public void put(String key, CogPrimalType value) {
            this.data.put(key, value);
            this.m_77762_();
        }

        public CogPrimalType get(String key) {
            return this.data.get(key);
        }

        public void remove(String key) {
            this.data.remove(key);
            this.m_77762_();
        }
    }

    public static class TestEnvironment
    extends LibraryEnvironment {
        public TestEnvironment() {
            super("test_environment");
        }

        @Override
        public void dispatchScript(String name) {
            CogScriptDispatcher.dispatch("cog/test." + name, this);
        }

        @Override
        public void dispatchScript(String name, ScriptStorage storage) {
            CogScriptDispatcher.dispatch("cog/test." + name, storage, (CogScriptEnvironment)this);
        }

        @Override
        public String getScript(String name) {
            return "cog/test." + name;
        }
    }
}

