/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.cog.CogTestCallback;
import com.storyanvil.cogwheel.infrastructure.cog.StoryLevel;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.network.belt.BeltCommunications;
import com.storyanvil.cogwheel.network.belt.BeltPacket;
import com.storyanvil.cogwheel.network.mc.AnimationDataBound;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.LabelCloseable;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import com.storyanvil.cogwheel.util.ScriptLineHandler;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.WeakList;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storyanvil_cogwheel")
@Api.Internal
@ApiStatus.Internal
public class EventBus {
    @Api.Internal
    @ApiStatus.Internal
    protected static final List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> queue = new ArrayList<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>>();
    @Api.Internal
    @ApiStatus.Internal
    protected static final List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> clientQueue = new ArrayList<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>>();
    private static final StoryLevel level = new StoryLevel();
    @Api.Internal
    @ApiStatus.Internal
    public static BeltCommunications beltCommunications = null;
    @Api.Internal
    @ApiStatus.Internal
    public static ArrayList<ResourceLocation> serverSideAnimations = new ArrayList();
    private static final HashMap<String, WeakList<LabelCloseable>> labelListeners = new HashMap();

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void dataInjector(AddPackFindersEvent event) {
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void registerCommands(@NotNull RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"@storyanvil").requires(css -> css.m_6761_(1))).then(Commands.m_82127_((String)"dispatch-script").then(Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Script execution will be dispatched"));
            try {
                CogScriptEnvironment.dispatchScriptGlobal(ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"name").toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        })))).then(Commands.m_82127_((String)"dump").executes(ctx -> {
            StringBuilder sb = new StringBuilder("=== === === === === COGWHEEL ENGINE REPORT === === === === ===\n");
            sb.append("DATE: ").append(new Date());
            sb.append("\nMODDED: ").append((CharSequence)EventBus.guessIfModded()).append("\n");
            ObjectMonitor.dumpAll(sb);
            CogwheelEngine.LOGGER.warn("\n{}", (Object)sb);
            return 0;
        }))).then(Commands.m_82127_((String)"run-tests").executes(ctx -> {
            CogwheelExecutor.schedule(() -> {
                CogScriptEnvironment.TestEnvironment environment = new CogScriptEnvironment.TestEnvironment();
                File scripts = new File(Minecraft.m_91087_().f_91069_, "config/cog");
                for (File f : Objects.requireNonNull(scripts.listFiles(), "No scripts available")) {
                    String name = f.getName();
                    if (!name.startsWith("test.") || name.startsWith("test..")) continue;
                    ScriptStorage s = new ScriptStorage();
                    CogTestCallback callback = new CogTestCallback();
                    s.put("TEST", callback);
                    environment.dispatchScript(name.substring(5), s);
                    while (!callback.isComplete()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (callback.isSuccessful()) {
                        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("Test " + name + " completed!")).m_130938_(x -> x.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN))));
                        continue;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("Test " + name + " failed!")).m_130938_(x -> x.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED))));
                }
                environment.dispose();
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"All tests completed!"));
            });
            return 0;
        }))).then(Commands.m_82127_((String)"run-all-tests").executes(ctx -> {
            CogwheelExecutor.schedule(() -> {
                CogScriptEnvironment.TestEnvironment environment = new CogScriptEnvironment.TestEnvironment();
                File scripts = new File(Minecraft.m_91087_().f_91069_, "config/cog");
                for (File f : Objects.requireNonNull(scripts.listFiles(), "No scripts available")) {
                    String name = f.getName();
                    if (!name.startsWith("test.")) continue;
                    ScriptStorage s = new ScriptStorage();
                    CogTestCallback callback = new CogTestCallback();
                    s.put("TEST", callback);
                    environment.dispatchScript(name.substring(5), s);
                    while (!callback.isComplete()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (callback.isSuccessful()) {
                        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("Test " + name + " completed!")).m_130938_(x -> x.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN))));
                        continue;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("Test " + name + " failed!")).m_130938_(x -> x.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED))));
                }
                environment.dispose();
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"All tests completed!"));
            });
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cogwheel-belt").then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"host", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            beltCommunications = BeltCommunications.create(StringArgumentType.getString((CommandContext)ctx, (String)"host"));
            return 0;
        })))).then(Commands.m_82127_((String)"getLink").executes(ctx -> {
            if (beltCommunications == null) {
                ((CommandSourceStack)ctx.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)"No belt server is connected"));
                return 1;
            }
            String link = beltCommunications.getUserLink(((CommandSourceStack)ctx.getSource()).m_81375_());
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)("Click to open " + link + " | This will authorize you on " + beltCommunications.getRemoteServerName())).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link))));
            return 0;
        }))).then(Commands.m_82127_((String)"auth").then(Commands.m_82129_((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            if (beltCommunications == null) {
                ((CommandSourceStack)ctx.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)"No belt server is connected"));
                return 1;
            }
            String link = beltCommunications.getHost() + "/~";
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)("You will be authorized on " + beltCommunications.getRemoteServerName() + " as soon as possible.")).m_130946_("\nVisit " + link + " to check").m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link))));
            BeltPacket.createAuthCode(StringArgumentType.getString((CommandContext)ctx, (String)"code"), ((CommandSourceStack)ctx.getSource()).m_81375_().m_6302_());
            return 0;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"@storyclient").requires(css -> css.m_6761_(0))).then(Commands.m_82127_((String)"dialog").then(Commands.m_82129_((String)"answer", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"dialog", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String dialogID = StringArgumentType.getString((CommandContext)ctx, (String)"dialog");
            if (!CogwheelExecutor.getDefaultEnvironment().getDialogs().containsKey(dialogID)) {
                return 1;
            }
            Consumer<Integer> call = CogwheelExecutor.getDefaultEnvironment().getDialogs().get(dialogID);
            CogwheelExecutor.getDefaultEnvironment().getDialogs().remove(dialogID);
            call.accept(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"answer"));
            return 0;
        })))));
    }

    @NotNull
    private static StringBuilder guessIfModded() {
        StringBuilder modded = new StringBuilder();
        for (ScriptLineHandler handler : CogwheelRegistries.getLineHandlers()) {
            if (handler.getResourceLocation().m_135827_().equals("storyanvil_cogwheel")) continue;
            modded.append(" DETECTED CUSTOM LINE HANDLERS");
        }
        if (modded.isEmpty()) {
            modded.append("NO");
        } else {
            modded.insert(0, "YES:");
        }
        return modded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void tick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.LevelTickEvent event) {
        if (!event.level.m_46472_().m_135782_().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld"))) {
            return;
        }
        if (event.level.m_5776_()) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = clientQueue;
            synchronized (list) {
                try {
                    int size = clientQueue.size();
                    for (int i = 0; i < size; ++i) {
                        Bi<Consumer<TickEvent.LevelTickEvent>, Integer> e = clientQueue.get(i);
                        if (e.getB() < 2) {
                            e.getA().accept(event);
                            clientQueue.remove(i);
                            --i;
                            continue;
                        }
                        e.setB(e.getB() - 1);
                    }
                }
                catch (Exception e) {
                    CogwheelEngine.LOGGER.warn("Client Queue bound error", (Throwable)e);
                }
                return;
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            level.tick((ServerLevel)event.level);
            return;
        }
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = queue;
        synchronized (list) {
            try {
                for (int i = 0; i < queue.size(); ++i) {
                    Bi<Consumer<TickEvent.LevelTickEvent>, Integer> e = queue.get(i);
                    if (e.getB() < 2) {
                        try {
                            e.getA().accept(event);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        queue.remove(i);
                        --i;
                        continue;
                    }
                    e.setB(e.getB() - 1);
                }
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("Queue bound error", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void boundEvent(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StringBuilder sb = new StringBuilder();
            boolean a = true;
            for (ResourceLocation loc : serverSideAnimations) {
                if (a) {
                    a = false;
                } else {
                    sb.append("|");
                }
                sb.append(loc.toString());
            }
            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AnimationDataBound(sb.toString()));
        }
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void hitLabel(String label, StoryAction<?> action) {
        if (labelListeners.containsKey(label)) {
            WeakList<LabelCloseable> c = labelListeners.get(label);
            for (int i = 0; i < c.size(); ++i) {
                LabelCloseable closeable = c.get(i);
                if (closeable == null) continue;
                closeable.close(label, action);
            }
        }
    }

    @Api.Experimental(since="2.1.0")
    public static void register(String label, LabelCloseable closeable) {
        if (labelListeners.containsKey(label)) {
            labelListeners.get(label).add(closeable);
        } else {
            labelListeners.put(label, new WeakList<LabelCloseable>(closeable));
        }
    }

    @Contract(pure=true)
    @Api.Experimental(since="2.1.0")
    public static StoryLevel getStoryLevel() {
        return level;
    }
}

