/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.module;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.module.CMA;
import com.storyanvil.cogwheel.infrastructure.module.CogModule;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.CogExpressionFailure;
import java.util.ArrayList;
import java.util.Arrays;

public class ModuleProperty
implements PropertyHandler {
    private ArrayList<String> $lines;
    private CogModule $parent;
    private String[] $arguments;

    public ModuleProperty(ArrayList<String> lines, CogModule parent, String[] arguments) {
        this.$lines = lines;
        this.$parent = parent;
        this.$arguments = arguments;
    }

    @Override
    public CogPropertyManager handle(String name, ArgumentData arg, DispatchedScript script, Object o) {
        if (o == null) {
            o = new CMA(this.$parent);
        }
        CMA instance = (CMA)o;
        DispatchedScript $ = new DispatchedScript((ArrayList)this.$lines.clone(), this.$parent.getEnvironment()).setScriptName("PROPERTY");
        $.put("this", instance);
        CogPropertyManager[] args = arg.getArgs();
        if (args.length != this.$arguments.length) {
            throw new CogExpressionFailure("Invalid amount of arguments {" + args.length + "} of {" + this.$arguments.length + "}");
        }
        for (int i = 0; i < this.$arguments.length; ++i) {
            $.put(this.$arguments[i], args[i]);
        }
        $.lineDispatcher();
        return $.get("$");
    }

    public void dataFixer() {
        int i;
        for (i = 0; i < this.$arguments.length; ++i) {
            this.$arguments[i] = this.$arguments[i].trim();
        }
        for (i = 0; i < this.$lines.size(); ++i) {
            String line = this.$lines.get(i);
            if (!line.startsWith("*import") && !line.startsWith("*reimport")) continue;
            CogModule.dataFix.warn("Line {} was removed from property due to being in property", (Object)line);
            this.$lines.remove(i);
            --i;
        }
    }

    public String toString() {
        return "ModuleProperty{$lines=[" + String.join((CharSequence)"<|>", this.$lines) + "], $parent=" + String.valueOf(this.$parent) + ", $arguments=" + Arrays.toString(this.$arguments) + "}";
    }
}

