/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.belt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.storyanvil.cogwheel.network.belt.BeltCommunications;
import com.storyanvil.cogwheel.network.belt.Handlers;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BeltPacket {
    private final Type type;
    private final String[] data;

    @Contract(pure=true)
    private BeltPacket(Type type, String[] data) {
        this.type = type;
        this.data = data;
    }

    public Type getType() {
        return this.type;
    }

    public String[] getData() {
        return this.data;
    }

    public static void createAuthCode(String authCode, String playerName) {
        BeltPacket packet = new BeltPacket(Type.AUTH_CODE, new String[]{authCode, playerName});
        BeltCommunications.pushPacket(packet);
    }

    public static void createBeltMessage(String message) {
        BeltPacket packet = new BeltPacket(Type.SCRIPT_MESSAGE, new String[]{message});
        BeltCommunications.pushPacket(packet);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static BeltPacket parse(@NotNull JsonObject o) {
        JsonArray a = o.get("data").getAsJsonArray();
        String[] array = new String[a.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = a.getAsString();
        }
        return new BeltPacket(Type.valueOf(o.get("type").getAsString()), array);
    }

    public JsonObject toJSON() {
        JsonObject obj = new JsonObject();
        JsonArray a = new JsonArray();
        obj.addProperty("type", this.type.toString());
        for (String s : this.data) {
            a.add(s);
        }
        obj.add("data", (JsonElement)a);
        return obj;
    }

    public static enum Type {
        AUTH_CODE(Handlers::none),
        RUN_COMMAND(Handlers::cmd),
        DISPATCH_SCRIPT(Handlers::dispatchScript),
        SCRIPT_MESSAGE(Handlers::scriptMessage);

        public final Consumer<BeltPacket> handler;

        @Contract(pure=true)
        private Type(Consumer<BeltPacket> handler) {
            this.handler = handler;
        }
    }
}

