/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.network.mc.CogwheelClientPacketHandler;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DialogChoiceBound {
    private boolean close = false;
    private String request = "";
    private String dialogId = "";
    private String[] options = new String[0];
    private String npcName = "";
    private String texture = "";

    public static DialogChoiceBound close() {
        DialogChoiceBound bound = new DialogChoiceBound();
        bound.close = true;
        bound.dialogId = "";
        return bound;
    }

    public static DialogChoiceBound choice(String dialogId, String request, String[] options, String npcName, String texture) {
        DialogChoiceBound bound = new DialogChoiceBound();
        bound.request = request;
        bound.options = options;
        bound.dialogId = dialogId;
        bound.npcName = npcName;
        bound.texture = texture;
        return bound;
    }

    public static DialogChoiceBound choice(String dialogId, String request, List<String> options, String npcName, String texture) {
        String[] o = new String[options.size()];
        for (int i = 0; i < options.size(); ++i) {
            o[i] = options.get(i);
        }
        return DialogChoiceBound.choice(dialogId, request, o, npcName, texture);
    }

    public boolean isClose() {
        return this.close;
    }

    public String getRequest() {
        return this.request;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public String getNpcName() {
        return this.npcName;
    }

    public String getTexture() {
        return this.texture;
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeBoolean(this.close);
        StoryUtils.encodeString(byteBuf, this.dialogId);
        StoryUtils.encodeString(byteBuf, this.request);
        StoryUtils.encodeString(byteBuf, this.npcName);
        StoryUtils.encodeString(byteBuf, this.texture);
        byteBuf.writeInt(this.options.length);
        for (int i = 0; i < this.options.length; ++i) {
            StoryUtils.encodeString(byteBuf, this.options[i]);
        }
    }

    public static DialogChoiceBound decode(FriendlyByteBuf byteBuf) {
        DialogChoiceBound bound = new DialogChoiceBound();
        bound.close = byteBuf.readBoolean();
        bound.dialogId = StoryUtils.decodeString(byteBuf);
        bound.request = StoryUtils.decodeString(byteBuf);
        bound.npcName = StoryUtils.decodeString(byteBuf);
        bound.texture = StoryUtils.decodeString(byteBuf);
        int optionsLength = byteBuf.readInt();
        String[] options = new String[optionsLength];
        for (int i = 0; i < optionsLength; ++i) {
            options[i] = StoryUtils.decodeString(byteBuf);
        }
        bound.options = options;
        return bound;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public String toString() {
        return "DialogBound{close=" + this.close + ", request='" + this.request + "', dialogId='" + this.dialogId + "', options=" + Arrays.toString(this.options) + "}";
    }

    private /* synthetic */ Callable lambda$handle$1(Supplier contextSupplier) {
        return () -> this.lambda$handle$0((Supplier)contextSupplier);
    }

    private /* synthetic */ Object lambda$handle$0(Supplier contextSupplier) throws Exception {
        return CogwheelClientPacketHandler.dialogChoiceBound(this, contextSupplier);
    }
}

