/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DialogResponseBound {
    private final String dialogId;
    private final int responseId;

    public DialogResponseBound(String dialogId, int responseId) {
        this.dialogId = dialogId;
        this.responseId = responseId;
    }

    public void encode(FriendlyByteBuf byteBuf) {
        StoryUtils.encodeString(byteBuf, this.dialogId);
        byteBuf.writeInt(this.responseId);
    }

    public static DialogResponseBound decode(FriendlyByteBuf byteBuf) {
        DialogResponseBound bound = new DialogResponseBound(StoryUtils.decodeString(byteBuf), byteBuf.readInt());
        return bound;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> CogwheelExecutor.schedule(() -> {
            Consumer<Integer> call = CogwheelExecutor.getDefaultEnvironment().getDialogs().get(this.dialogId);
            CogwheelExecutor.getDefaultEnvironment().getDialogs().remove(this.dialogId);
            call.accept(this.responseId);
        }));
        contextSupplier.get().setPacketHandled(true);
    }

    public String toString() {
        return "DialogResponseBound{dialogId='" + this.dialogId + "', responseId=" + this.responseId + "}";
    }
}

