/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.registry;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogManifest;
import com.storyanvil.cogwheel.infrastructure.cog.CogMaster;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.ForEachManager;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.module.CogModule;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.CogExpressionFailure;
import com.storyanvil.cogwheel.util.ScriptLineHandler;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CogwheelRegistries {
    private static final List<Bi<String, Function<DispatchedScript, CogPropertyManager>>> defaultVariables = new ArrayList<Bi<String, Function<DispatchedScript, CogPropertyManager>>>();
    private static final ArrayList<ScriptLineHandler> lineHandlers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void register(@NotNull ScriptLineHandler factory) {
        ArrayList<ScriptLineHandler> arrayList = lineHandlers;
        synchronized (arrayList) {
            ResourceLocation id = factory.getResourceLocation();
            if (id.m_135827_().equals("storyanvil") || id.m_135827_().equals("storyanvil_cogwheel")) {
                throw new IllegalArgumentException("ActionFactory with namespace \"" + id.m_135827_() + "\" cannot be registered as this namespace is reserved for internal purposes");
            }
            lineHandlers.add(Objects.requireNonNull(factory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Internal
    @ApiStatus.Internal
    protected static void registerInternal(@NotNull ScriptLineHandler factory) {
        ArrayList<ScriptLineHandler> arrayList = lineHandlers;
        synchronized (arrayList) {
            lineHandlers.add(Objects.requireNonNull(factory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void register(@NotNull String name, @NotNull Function<DispatchedScript, CogPropertyManager> f) {
        List<Bi<String, Function<DispatchedScript, CogPropertyManager>>> list = defaultVariables;
        synchronized (list) {
            if (name.equalsIgnoreCase("storyanvil") || name.equalsIgnoreCase("cogwheel")) {
                throw new IllegalArgumentException("Name not permitted");
            }
            defaultVariables.add(new Bi<String, Function<DispatchedScript, CogPropertyManager>>(name, f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Internal
    @ApiStatus.Internal
    protected static void registerInternal(@NotNull String name, @NotNull Function<DispatchedScript, CogPropertyManager> f) {
        List<Bi<String, Function<DispatchedScript, CogPropertyManager>>> list = defaultVariables;
        synchronized (list) {
            defaultVariables.add(new Bi<String, Function<DispatchedScript, CogPropertyManager>>(name, f));
        }
    }

    @Contract(pure=true)
    @Api.Internal
    @ApiStatus.Internal
    public static List<ScriptLineHandler> getLineHandlers() {
        return lineHandlers;
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void registerDefaultObjects() {
        CogwheelRegistries.registerInternal(new ScriptLineHandler(){

            @Override
            public byte handle(@NotNull String line, @NotNull DispatchedScript script) {
                if (line.startsWith("#") || line.isEmpty()) {
                    return ScriptLineHandler.continueReading();
                }
                return ScriptLineHandler.ignore();
            }

            @Override
            @NotNull
            public ResourceLocation getResourceLocation() {
                return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"comment");
            }
        });
        CogwheelRegistries.registerInternal(new ScriptLineHandler(){

            @Override
            public byte handle(@NotNull String line, @NotNull DispatchedScript script) {
                if (line.startsWith("if (") && line.endsWith("{")) {
                    int endBracket = line.lastIndexOf(41);
                    String expression = line.substring(4, endBracket);
                    Bi<Byte, CogPropertyManager> out = CogwheelRegistries.expressionHandler(expression, script, false);
                    CogPropertyManager cogPropertyManager = out.getB();
                    if (cogPropertyManager instanceof CogBool) {
                        CogBool bool = (CogBool)cogPropertyManager;
                        if (bool.getValue()) {
                            int level = 0;
                            for (int i = 0; i < script.linesLeft(); ++i) {
                                String l = script.peekLine(i);
                                if (l.endsWith("{")) {
                                    ++level;
                                    continue;
                                }
                                if (!l.equals("}") || --level > -1) continue;
                                script.removeLine(i);
                                break;
                            }
                            return ScriptLineHandler.continueReading();
                        }
                        CogwheelRegistries.skipCurrentLevel(script);
                        return ScriptLineHandler.continueReading();
                    }
                    throw new CogExpressionFailure("If expression returned non-CogBool");
                }
                return ScriptLineHandler.ignore();
            }

            @Override
            @NotNull
            public ResourceLocation getResourceLocation() {
                return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"if");
            }
        });
        CogwheelRegistries.registerInternal(new ScriptLineHandler(){

            @Override
            public byte handle(@NotNull String line, @NotNull DispatchedScript script) {
                int endLine;
                Object track;
                ForEachManager manager;
                if (!line.startsWith("for (") || !line.endsWith(") {")) {
                    return ScriptLineHandler.ignore();
                }
                line = line.substring(5, line.length() - 3);
                int in = CogwheelRegistries.indexOfKeyword(line, "in");
                String left = line.substring(0, in).trim();
                String right = line.substring(in + 2).trim();
                CogPropertyManager arr = CogwheelRegistries.expressionHandler(right, script, false).getB();
                if (arr instanceof ForEachManager) {
                    manager = (ForEachManager)arr;
                    track = manager.createForEach(script);
                    Bi<CogPropertyManager, Object> m = manager.getForEach(track);
                    if (m == null) {
                        CogwheelRegistries.skipCurrentLevel(script);
                        return ScriptLineHandler.continueReading();
                    }
                    track = m.getB();
                    script.put(left, m.getA());
                    endLine = -1;
                    int level = 0;
                    for (int i = 0; i < script.linesLeft(); ++i) {
                        String l = script.peekLine(i);
                        if (l.endsWith("{")) {
                            ++level;
                            continue;
                        }
                        if (!l.equals("}") || --level > -1) continue;
                        script.defuseLine(i);
                        endLine = i - 1;
                        break;
                    }
                    if (endLine == -1) {
                        throw new CogExpressionFailure("Foreach tail bracket mismatch!");
                    }
                } else {
                    throw new CogExpressionFailure("Foreach argument is not a ForEachManager!");
                }
                script.stopLineUnloading();
                script.plantHandler(new ForEachInternal(track, manager, left, endLine), endLine);
                return ScriptLineHandler.continueReading();
            }

            @Override
            @NotNull
            public ResourceLocation getResourceLocation() {
                return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"foreach");
            }
        });
        CogwheelRegistries.registerInternal(new ScriptLineHandler(){

            @Override
            public byte handle(@NotNull String line, @NotNull DispatchedScript script) throws Exception {
                ResourceLocation loc;
                String library;
                if (!line.startsWith("*")) {
                    return ScriptLineHandler.ignore();
                }
                boolean reload = false;
                if (line.startsWith("*import ")) {
                    library = line.substring(8);
                } else if (line.startsWith("*reimport ")) {
                    library = line.substring(10);
                    reload = true;
                } else {
                    if (line.startsWith("*return ")) {
                        String expression = line.substring(8);
                        CogPropertyManager exp = CogwheelRegistries.expressionHandler(expression, script, false).getB();
                        script.put("$", exp);
                        script.clearLines();
                        return ScriptLineHandler.continueReading();
                    }
                    throw new CogExpressionFailure("STAR Expression is invalid");
                }
                try {
                    loc = ResourceLocation.parse((String)(library + ".sam"));
                }
                catch (Throwable t) {
                    throw new CogExpressionFailure("STAR Expression is invalid", t);
                }
                CogScriptEnvironment environment = CogScriptEnvironment.getEnvironment(loc);
                ResourceLocation modLoc = CogwheelExecutor.getDefaultEnvironment().getModuleLoc(environment, loc.m_135815_());
                CogModule module = CogwheelExecutor.getDefaultEnvironment().getModule(modLoc);
                if (!reload) {
                    boolean bl = reload = module == null;
                }
                if (reload) {
                    module = CogModule.build(environment, loc.m_135815_());
                    CogwheelExecutor.getDefaultEnvironment().putModule(modLoc, module);
                }
                String actualName = loc.m_135815_().substring(0, loc.m_135815_().length() - 4);
                script.put(actualName.substring(0, 1).toUpperCase() + actualName.substring(1), module);
                return ScriptLineHandler.continueReading();
            }

            @Override
            @NotNull
            public ResourceLocation getResourceLocation() {
                return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"star");
            }
        });
        CogwheelRegistries.registerInternal(new ScriptLineHandler(){

            @Override
            public byte handle(@NotNull String _line, @NotNull DispatchedScript script) {
                Bi<Byte, CogPropertyManager> parseOutput = CogwheelRegistries.expressionHandler(_line, script, true);
                return parseOutput.getA();
            }

            @Override
            @NotNull
            public ResourceLocation getResourceLocation() {
                return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"expression_handler");
            }
        });
        CogwheelRegistries.registerInternal("Cogwheel", script -> CogMaster.getInstance());
        CogwheelRegistries.registerInternal("MANIFEST", script -> CogManifest.getInstance());
        CogwheelRegistries.registerInternal("true", script -> CogBool.TRUE);
        CogwheelRegistries.registerInternal("false", script -> CogBool.FALSE);
    }

    private static void skipCurrentLevel(@NotNull DispatchedScript script) {
        int level = 0;
        String l = script.pullLine();
        while (l != null) {
            if (l.endsWith("{")) {
                ++level;
            } else if (l.equals("}") && --level <= -1) break;
            l = script.pullLine();
        }
    }

    public static void putDefaults(ScriptStorage storage, DispatchedScript script) {
        for (Bi<String, Function<DispatchedScript, CogPropertyManager>> pair : defaultVariables) {
            storage.put(pair.getA(), pair.getB().apply(script));
        }
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Bi<Byte, CogPropertyManager> expressionHandler(String line, DispatchedScript script, boolean allowBlocking) {
        line = line.trim();
        int currentStart = 0;
        StringBuilder variable = new StringBuilder();
        boolean hasVariable = false;
        for (int i = currentStart; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '=') {
                hasVariable = true;
                variable = new StringBuilder(variable.toString().trim());
                currentStart = i + 1;
                break;
            }
            if (c == '.') {
                variable = null;
                break;
            }
            variable.append(c);
        }
        if (!hasVariable) {
            variable = null;
        }
        String leftLine = line.substring(currentStart).stripLeading();
        CogPropertyManager cm = null;
        if (leftLine.startsWith("\"") && leftLine.endsWith("\"")) {
            cm = new CogString(leftLine.substring(1, leftLine.length() - 1));
        } else if (leftLine.startsWith("^")) {
            cm = !leftLine.endsWith("L") ? new CogInteger(leftLine.substring(1)) : new CogLong(leftLine.substring(1, leftLine.length() - 1));
        }
        if (cm != null) {
            if (variable != null) {
                script.put(variable.toString(), cm);
            }
            return new Bi<Byte, Object>(ScriptLineHandler.continueReading(), cm);
        }
        StringBuilder currentName = new StringBuilder();
        int depth = 0;
        ArrayList<String> chainCalls = new ArrayList<String>();
        for (int i = currentStart; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '.' && depth == 0) {
                chainCalls.add(currentName.toString());
                currentName = new StringBuilder();
                continue;
            }
            if (c == '(') {
                ++depth;
                currentName.append(c);
                continue;
            }
            if (c == ')') {
                if (--depth < 0) {
                    throw new CogExpressionFailure("Closing bracket mismatch! \"" + line + "\"");
                }
                currentName.append(c);
                continue;
            }
            currentName.append(c);
        }
        if (depth != 0) {
            throw new CogExpressionFailure("Tail closing bracket mismatch! \"" + line + "\"");
        }
        chainCalls.add(currentName.toString());
        if (((String)chainCalls.get(0)).endsWith(")")) {
            throw new CogExpressionFailure("Expression does not have first step! \"" + line + "\"");
        }
        if (chainCalls.size() == 1) {
            cm = CogPropertyManager.noNull(script.get((String)chainCalls.get(0)));
            if (variable != null) {
                script.put(variable.toString(), cm);
            }
            return new Bi<Byte, CogPropertyManager>(ScriptLineHandler.continueReading(), cm);
        }
        @NotNull CogPropertyManager manager = CogPropertyManager.noNull(script.get(((String)chainCalls.get(0)).stripLeading()));
        for (int i = 1; i < chainCalls.size(); ++i) {
            String step = (String)chainCalls.get(i);
            if (!step.endsWith(")")) {
                throw new CogExpressionFailure("Invalid step: \"" + step + "\"! \"" + line + "\"");
            }
            int firstBracket = step.indexOf(40);
            String propName = step.substring(0, firstBracket);
            ArgumentData argumentData = ArgumentData.createFromString(step.substring(firstBracket + 1, step.length() - 1), script);
            if (!manager.hasOwnProperty(propName)) {
                throw new CogExpressionFailure(manager.getClass().getCanonicalName() + " object does not have property \"" + propName + "\"! \"" + line + "\"");
            }
            try {
                manager = CogPropertyManager.noNull(manager.getProperty(propName, argumentData, script));
                continue;
            }
            catch (PreventSubCalling preventSubCalling) {
                if (!allowBlocking) {
                    throw new CogExpressionFailure("SubCalling Prevention is not allowed in this context! \"" + line + "\"");
                }
                preventSubCalling.getPostPrevention().prevent(variable != null ? variable.toString() : null);
                return new Bi<Byte, CogPropertyManager>(ScriptLineHandler.blocking(), manager);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Expression handler caught while getting property. ArgData: " + String.valueOf(argumentData), e);
            }
        }
        if (variable != null) {
            script.put(variable.toString(), manager);
        }
        return new Bi<Byte, CogPropertyManager>(ScriptLineHandler.continueReading(), manager);
    }

    public static void skip(String label, @NotNull DispatchedScript script) {
        String line = script.pullLine();
        while (!line.equals(label)) {
            line = script.pullLine();
            if (line != null) continue;
            throw new RuntimeException("Skip failed. No label found");
        }
    }

    public static int indexOfKeyword(@NotNull String line, @NotNull String keyword) {
        boolean inQuotes = false;
        StringBuilder currentWord = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ' ') {
                if (currentWord.toString().equals(keyword)) {
                    return i - currentWord.length();
                }
                currentWord = new StringBuilder();
                continue;
            }
            currentWord.append(c);
        }
        return -1;
    }

    @ApiStatus.Internal
    public static class ForEachInternal
    implements ScriptLineHandler {
        private final Object track;
        private final ForEachManager manager;
        private final String varName;
        private final int planningSchedule;

        @Contract(pure=true)
        public ForEachInternal(Object track, ForEachManager manager, String varName, int planningSchedule) {
            this.track = track;
            this.manager = manager;
            this.varName = varName;
            this.planningSchedule = planningSchedule;
        }

        @Override
        public byte handle(@NotNull String line, @NotNull DispatchedScript script) throws Exception {
            Bi<CogPropertyManager, Object> bi = this.manager.getForEach(this.track);
            if (bi == null) {
                script.continueUnloadingLines();
                script.removeUnloadedLines();
                return ScriptLineHandler.continueReading();
            }
            script.stopLineUnloading();
            script.put(this.varName, bi.getA());
            script.continueUnloadingLines();
            script.plantHandler(new ForEachInternal(bi.getB(), this.manager, this.varName, this.planningSchedule), this.planningSchedule);
            return ScriptLineHandler.continueReading();
        }

        @Override
        @NotNull
        public ResourceLocation getResourceLocation() {
            return ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)("foreach_internal/" + this.manager.getClass().getCanonicalName().toLowerCase() + "." + this.manager.hashCode() + "/" + this.track.getClass().getCanonicalName().toLowerCase() + "." + this.track.hashCode()));
        }
    }
}

