/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StoryAction<T>
implements ObjectMonitor.IMonitored,
CogPropertyManager {
    private static final ObjectMonitor<StoryAction<?>> MONITOR = new ObjectMonitor();
    private String actionLabel = null;
    private static final EasyPropManager MANAGER = new EasyPropManager("storyAction", StoryAction::registerProps);

    public abstract void proceed(T var1);

    public abstract boolean freeToGo(T var1);

    public String toString() {
        return this.getClass().getName() + "$ACT#";
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public void hitLabel() {
        if (this.actionLabel == null) {
            return;
        }
        EventBus.hitLabel(this.actionLabel, this);
    }

    public StoryAction() {
        MONITOR.register(this);
    }

    @Override
    public void reportState(@NotNull StringBuilder sb) {
        sb.append(this);
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("setLabel", (name, args, script, o) -> {
            StoryAction action = (StoryAction)o;
            action.setActionLabel(args.getString(0));
            return action;
        });
        manager.reg("getLabel", (name, args, script, o) -> {
            StoryAction action = (StoryAction)o;
            return new CogString(action.getActionLabel());
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o == this;
    }

    public static abstract class Ticking<T>
    extends StoryAction<T> {
        private int ticksLeft;

        public Ticking(int ticksLeft) {
            this.ticksLeft = ticksLeft;
        }

        @Override
        public boolean freeToGo(T myself) {
            if (this.ticksLeft > 0) {
                --this.ticksLeft;
                return false;
            }
            this.onEnding();
            this.hitLabel();
            return true;
        }

        public void onEnding() {
        }
    }

    public static abstract class Instant<T>
    extends StoryAction<T> {
        @Override
        public boolean freeToGo(T myself) {
            this.hitLabel();
            return true;
        }
    }
}

