/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CogLong
implements CogPropertyManager,
CogPrimalType {
    private static final EasyPropManager MANAGER = new EasyPropManager("long", CogLong::registerProps);
    private long value;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("add", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            i.value += args.requireLong(0);
            return i;
        });
        manager.reg("subtract", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            i.value -= args.requireLong(0);
            return i;
        });
        manager.reg("multiply", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            i.value *= args.requireLong(0);
            return i;
        });
        manager.reg("divide", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            i.value /= args.requireLong(0);
            return i;
        });
        manager.reg("clamp", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            long min = args.requireLong(0);
            long max = args.requireLong(1);
            if (i.value < min) {
                i.value = min;
            }
            if (i.value > max) {
                i.value = max;
            }
            return i;
        });
        manager.reg("abs", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            i.value = Math.abs(i.value);
            return i;
        });
        manager.reg("toDouble", (name, args, script, o) -> {
            CogLong i = (CogLong)o;
            return new CogDouble(i.value);
        });
        manager.reg("clone", (name, args, script, o) -> {
            CogLong str = (CogLong)o;
            return new CogLong(str.value);
        });
        manager.reg("smaller", (name, args, script, o) -> {
            CogLong str = (CogLong)o;
            return CogBool.getInstance(str.value < args.requireLong(0));
        });
        manager.reg("bigger", (name, args, script, o) -> {
            CogLong str = (CogLong)o;
            return CogBool.getInstance(str.value > args.requireLong(0));
        });
    }

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogLong(long value) {
        this.value = value;
    }

    @Api.Stable(since="2.0.0")
    public CogLong(String value) {
        this(Long.parseLong(value));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equalsTo(CogPropertyManager o) {
        if (o instanceof CogLong) {
            CogLong other = (CogLong)o;
            return other.value == this.value;
        }
        return false;
    }

    @Contract(pure=true)
    public long getValue() {
        return this.value;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String convertToString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    @Contract(pure=true)
    public byte getPrimalID() {
        return 0;
    }

    @Override
    public void putPrimal(@NotNull CompoundTag tag, String key) {
        tag.m_128356_(key, this.value);
    }
}

