/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogPlayer
extends CogEntity
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("player", CogPlayer::registerProps);
    private WeakReference<ServerPlayer> player;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("sendMessage", (name, args, script, o) -> {
            CogPlayer p = (CogPlayer)o;
            if (p.player.refersTo(null)) {
                throw new RuntimeException("Player got unloaded");
            }
            ((ServerPlayer)p.player.get()).m_213846_((Component)Component.m_237113_((String)args.getString(0)));
            return null;
        });
        manager.reg("toEntity", (name, args, script, o) -> new CogEntity((Entity)((CogPlayer)o).player.get()));
        manager.reg("takeItem", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            ServerPlayer p = Objects.requireNonNull((ServerPlayer)pll.player.get(), "player got unloaded");
            p.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
            return null;
        });
        manager.reg("getStoryTag", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            ServerPlayer p = Objects.requireNonNull((ServerPlayer)pll.player.get(), "player got unloaded");
            CompoundTag shareTag = p.m_21120_(InteractionHand.MAIN_HAND).getShareTag();
            if (shareTag == null) {
                return null;
            }
            String s = shareTag.m_128461_("story");
            return new CogString(s);
        });
    }

    @Api.Experimental(since="2.0.0")
    public CogPlayer(@NotNull WeakReference<ServerPlayer> player) {
        super((Entity)player.get());
        this.player = player;
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        if (o instanceof CogPlayer) {
            CogPlayer other = (CogPlayer)o;
            return other.player.equals(this.player);
        }
        return false;
    }
}

