/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogTestCallback
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("testcallback", CogTestCallback::registerProps);
    private boolean complete = false;
    private boolean successful = true;

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("done", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            callback.complete = true;
            return null;
        });
        manager.reg("assertEquals", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            if (callback.successful) {
                CogPropertyManager a = args.get(0);
                CogPropertyManager b = args.get(1);
                callback.successful = a.equalsTo(b);
                if (!callback.successful) {
                    CogwheelExecutor.log.warn("TEST ASSERTION FAILED! ASSERTED EQUALS, BUT {} != {}", (Object)a.convertToString(), (Object)b.convertToString());
                }
            }
            return null;
        });
        manager.reg("debugWait", (name, args, script, o) -> {
            try {
                Thread.sleep(args.requireInt(0));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return false;
    }
}

