/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.entity.NPC;
import com.storyanvil.cogwheel.items.InspectorItem;
import com.storyanvil.cogwheel.neoforge.data.NbtAttachment;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.UseCooldown;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.lwjgl.glfw.GLFW;

import java.util.Optional;
import java.util.function.Supplier;

public class NeoRegistry {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create(NeoForgeRegistries.ATTACHMENT_TYPES, CogwheelEngine.MODID);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create(BuiltInRegistries.ITEM, CogwheelEngine.MODID);
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.createEntities(CogwheelEngine.MODID);

    public static final Supplier<AttachmentType<NbtAttachment>> DATA = ATTACHMENT_TYPES.register(
            "data", () -> AttachmentType.serializable(() -> new NbtAttachment()).build()
    );
    public static final Supplier<EntityType<NPC>> NPC = ENTITIES.register("npc", k -> EntityType.Builder.of(NPC::new, MobCategory.MISC)
            .sized(0.6f, 1.8f)
            .build(ResourceKey.create(Registries.ENTITY_TYPE, k)));
    public static final Supplier<Item> INSPECTOR = ITEMS.register("inspector", k -> new InspectorItem(new Item.Properties()
            .stacksTo(1).fireResistant().rarity(Rarity.EPIC).component(DataComponents.USE_COOLDOWN, new UseCooldown(0.25f, Optional.of(ResourceLocation.fromNamespaceAndPath(CogwheelEngine.MODID, "devtools")))).setId(ResourceKey.create(Registries.ITEM, k))));
    public static Lazy<KeyMapping> OPEN_DEVUI = Lazy.of(() -> new KeyMapping("ui.storyanvil_cogwheel.dev_ui", KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, GLFW.GLFW_KEY_GRAVE_ACCENT, "ui.storyanvil_cogwheel"));
}
