/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.neoforge.data;

import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class NbtAttachment implements INBTSerializable<CompoundTag> {
    private CompoundTag compound;

    public NbtAttachment() {
        this.compound = new CompoundTag();
    }

    public NbtAttachment(CompoundTag compound) {
        this.compound = compound;
    }

    public CompoundTag getCompound() {
        return compound;
    }

    public void setCompound(CompoundTag compound) {
        this.compound = compound;
    }

    @Override
    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.@NotNull Provider arg) {
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.@NotNull Provider arg, @NotNull CompoundTag arg2) {
        compound = arg2;
    }
}
