/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.client.devui.DevHighlighters;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevDeleteLine;
import com.storyanvil.cogwheel.network.devui.DevEditorLine;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevEnterCallback;
import com.storyanvil.cogwheel.network.devui.DevFlush;
import com.storyanvil.cogwheel.network.devui.DevInsertLine;
import com.storyanvil.cogwheel.network.devui.DevRunAndFlush;
import com.storyanvil.cogwheel.network.devui.DevTypeCallback;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DWCodeEditor
extends DWTabbedView.Tab {
    private static final HashMap<ResourceLocation, DWCodeEditor> editors = new HashMap();
    private ResourceLocation rl;
    private String name;
    private ArrayList<Bi<String, MutableComponent>> code = new ArrayList();
    private ArrayList<Cursor> cursors = new ArrayList();
    private int scroll = 0;
    private int codeLeft = 0;
    private int scrollHor = 0;
    private boolean shift = false;
    private Highlighter highlighter;
    private String myName;
    private Cursor mine = null;
    private float blinker = 0.0f;
    private boolean blink = false;
    private static final MutableComponent EMPTY = Component.literal((String)"UNHIGHLIGHTED").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final MutableComponent NODATA = Component.literal((String)"NO DATA").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private static final MutableComponent FAILURE = Component.literal((String)"HIGHLIGHTER FAILURE").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});

    public static DWCodeEditor getOrCreateEditor(ResourceLocation script) {
        if (editors.containsKey(script)) {
            return editors.get(script);
        }
        DWCodeEditor editor = new DWCodeEditor(script);
        editors.put(script, editor);
        DevUI.instance.tabs.openAndSelect(editor);
        return editor;
    }

    private DWCodeEditor(ResourceLocation rl) {
        this.rl = rl;
        this.name = rl.toString();
        String path = rl.getPath();
        this.highlighter = DWCodeEditor.getHighlighterByFileName(path);
        this.myName = Minecraft.getInstance().player.getScoreboardName();
    }

    public static Highlighter getHighlighterByFileName(String name) {
        if (name.endsWith(".sad")) {
            return new DevHighlighters.StoryAnvilDialog();
        }
        if (name.endsWith(".sa")) {
            return new DevHighlighters.CogScript();
        }
        if (name.endsWith(".json") || name.endsWith(".saui")) {
            return new DevHighlighters.JSON();
        }
        return new DevHighlighters.Empty();
    }

    public static DWCodeEditor get(ResourceLocation lc) {
        return editors.get(lc);
    }

    public static void delete(ResourceLocation lc) {
        DWCodeEditor editor = editors.get(lc);
        DevUI.instance.tabs.close(editor);
        editors.remove(lc);
    }

    @Override
    public void renderS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        int i;
        int y = top;
        g.enableScissor(left, top, right, bottom);
        int codeLeftt = this.codeLeft - this.scrollHor;
        for (i = this.scroll; i < this.code.size(); ++i) {
            MutableComponent b = this.code.get(i).getB();
            this.draw(g, codeLeftt, y, (Component)(b == null ? EMPTY : b), this.ui().font);
            Objects.requireNonNull(this.ui().font);
            y += 9;
        }
        g.disableScissor();
        this.blinker += partialTick;
        if (this.blinker > 10.0f) {
            this.blinker = 0.0f;
            this.blink = !this.blink;
        }
        for (i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            Objects.requireNonNull(this.ui().font);
            int t = 9 * (c.line - this.scroll) + top;
            int drawingLeft = c.drawingLeft + this.codeLeft;
            int right1 = drawingLeft + 1;
            Objects.requireNonNull(this.ui().font);
            int bottom1 = t + 9;
            if (this.blink) {
                this.fill(g, drawingLeft, t, right1, bottom1, c.color);
            }
            if (!StoryUtils.isHovering(mouseX, mouseY, drawingLeft - 2, right1 + 2, t - 2, bottom1 + 2)) continue;
            String tooltip = c.name;
            int tooltipWidth = this.ui().font.width(tooltip) + 10;
            Objects.requireNonNull(this.ui().font);
            int tooltipHeight = 9 + 10;
            this.fill(g, mouseX, mouseY, mouseX + tooltipWidth, mouseY + tooltipHeight, c.color);
            this.draw(g, mouseX + 5, mouseY + 5, tooltip, this.ui().font);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount != 0.0) {
            this.scroll = Mth.clamp((int)(this.scroll + (verticalAmount > 0.0 ? -1 : 1)), (int)0, (int)(this.code.size() - 1));
        }
        if (horizontalAmount != 0.0) {
            this.scrollHor = Math.max(this.scrollHor + (horizontalAmount > 0.0 ? -4 : 4), 0);
        }
        return true;
    }

    @Override
    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.codeLeft = this.getLeft() + 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setCode(String code) {
        int i;
        this.code.clear();
        String[] lines = code.split("\n");
        for (i = 0; i < lines.length; ++i) {
            this.code.add(new Bi<String, MutableComponent>(lines[i], EMPTY));
        }
        for (i = 0; i < lines.length; ++i) {
            this.highlight(i);
        }
    }

    public synchronized void highlight(int line) {
        try {
            MutableComponent c = this.highlighter.highlight(line, this.code, this.code.get(line).getA());
            this.code.get(line).setB(c);
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Trying to highlight line \"{}\" with {}", new Object[]{this.code.get(line).getA(), this.highlighter.getClass().getCanonicalName(), e});
            this.code.get(line).setB(FAILURE);
        }
        this.recomputeCursors();
    }

    private synchronized Cursor getCursor(String name) {
        for (int i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            if (!c.name.equals(name)) continue;
            return c;
        }
        return null;
    }

    public synchronized void handle(DevEditorLine devEditorLine) {
        Bi<String, MutableComponent> line;
        if (devEditorLine.linesTotal() != this.code.size()) {
            if (this.code.size() > devEditorLine.linesTotal()) {
                CogwheelNetwork.sendToServer(new DevEditorState(this.rl, (byte)-127));
                return;
            }
            while (this.code.size() < devEditorLine.linesTotal()) {
                this.code.add(new Bi<String, MutableComponent>("", Component.empty()));
            }
        }
        if ((line = this.code.get(devEditorLine.lineNumber())).getA().equals(devEditorLine.line())) {
            return;
        }
        line.setA(devEditorLine.line());
        this.highlight(devEditorLine.lineNumber());
        this.recomputeCursors();
    }

    public synchronized void handle(DevEditorUserDelta delta) {
        Cursor c = this.getCursor(delta.name());
        if (c == null) {
            c = new Cursor();
            c.editor = this;
            c.name = delta.name();
            this.cursors.add(c);
            if (delta.name().equals(this.myName)) {
                this.mine = c;
            }
        }
        c.line = delta.line();
        c.pos = Mth.clamp((int)delta.pos(), (int)0, (int)this.code.get(delta.line()).getA().length());
        c.selectNextChars = delta.selected();
        c.color = delta.color();
        this.recomputeCursors();
    }

    public synchronized void recomputeCursors() {
        for (int i = 0; i < this.cursors.size(); ++i) {
            Cursor c = this.cursors.get(i);
            c.compute(this.code.get(c.line));
        }
    }

    @Override
    public boolean closingRequest() {
        CogwheelNetwork.sendToServer(new DevEditorState(this.rl, (byte)-128));
        return true;
    }

    public boolean keyPressed(int code, int scanCode, int mods) {
        boolean bl = this.shift = (mods & 1) == 1;
        if (code == 263) {
            if (this.mine.wrapLeft()) {
                this.mine.setPosSafe(this.mine.pos - 1);
            }
        } else if (code == 262) {
            if (this.mine.wrapRight()) {
                this.mine.setPosSafe(this.mine.pos + 1);
            }
        } else if (code == 265) {
            this.mine.setLineSafe(this.mine.line - 1);
        } else if (code == 264) {
            this.mine.setLineSafe(this.mine.line + 1);
        } else if (code == 259) {
            CogwheelNetwork.sendToServer(new DevTypeCallback(this.rl, "<backspace>", this.mine.toDelta()));
        } else if (code == 261) {
            CogwheelNetwork.sendToServer(new DevTypeCallback(this.rl, "<delete>", this.mine.toDelta()));
        } else if (code == 268) {
            this.mine.setPosSafe(0);
        } else if (code == 269) {
            this.mine.setPosSafe(Integer.MAX_VALUE);
        } else if (code == 266) {
            this.mine.setLineSafe(0);
            this.mine.setPosSafe(0);
        } else if (code == 267) {
            this.mine.setLineSafe(Integer.MAX_VALUE);
            this.mine.setPosSafe(Integer.MAX_VALUE);
        } else {
            if (code == 83 && (mods & 2) == 2) {
                this.save();
                return true;
            }
            if (code == 257) {
                CogwheelNetwork.sendToServer(new DevEnterCallback(this.rl, "enter", this.mine.toDelta()));
            }
        }
        return false;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) != 1;
        return false;
    }

    public boolean charTyped(char c, int mods) {
        if (c == '`') {
            return true;
        }
        CogwheelNetwork.sendToServer(new DevTypeCallback(this.rl, "" + c, this.mine.toDelta()));
        return true;
    }

    public synchronized void handle(DevInsertLine delta) {
        this.code.add(delta.lineBefore() + 1, new Bi<String, MutableComponent>(delta.contents(), Component.empty()));
        this.highlight(delta.lineBefore() + 1);
        this.recomputeCursors();
    }

    public void handle(DevDeleteLine delta) {
        this.code.remove(delta.line());
        this.recomputeCursors();
    }

    public void run() {
        CogwheelNetwork.sendToServer(new DevRunAndFlush(this.rl));
    }

    public void save() {
        CogwheelNetwork.sendToServer(new DevFlush(this.rl));
    }

    public static class Cursor {
        private DWCodeEditor editor;
        private int line = 0;
        private int pos = 0;
        private int selectNextChars = 0;
        private String name = ">huynya<";
        private Component sup;
        private int color = 0;
        private boolean onEndOfLine = false;
        private int drawingLeft = 0;

        public String toString() {
            return "Cursor{line=" + this.line + ", pos=" + this.pos + ", selectNextChars=" + this.selectNextChars + ", sup=" + String.valueOf(this.sup) + ", name='" + this.name + "'}";
        }

        public void compute(Bi<String, MutableComponent> line) {
            this.sup = StoryUtils.subText(line.getB(), 0, this.pos + 1);
            this.drawingLeft = this.editor.ui().font.width((FormattedText)this.sup);
            this.onEndOfLine = this.pos == line.getA().length();
        }

        public boolean wrapRight() {
            if (this.onEndOfLine) {
                this.pos = 0;
                this.setLineSafe(this.line + 1);
                return false;
            }
            return true;
        }

        public boolean wrapLeft() {
            if (this.pos == 0 && this.line > 0) {
                --this.line;
                Bi<String, MutableComponent> prv = this.editor.code.get(this.line);
                this.pos = prv.getA().length();
                this.compute(prv);
                this.sync();
                return false;
            }
            return true;
        }

        public void setPosSafe(int pos) {
            Bi<String, MutableComponent> line = this.editor.code.get(this.line);
            this.pos = Mth.clamp((int)pos, (int)0, (int)line.getA().length());
            this.compute(line);
            this.sync();
        }

        public void setLineSafe(int line) {
            this.line = line = Mth.clamp((int)line, (int)0, (int)(this.editor.code.size() - 1));
            this.setPosSafe(this.pos);
        }

        public void sync() {
            this.editor.blink = true;
            this.editor.blinker = 0.0f;
            CogwheelNetwork.sendToServer(new DevEditorUserDelta(this.editor.rl, this.line, this.pos, this.selectNextChars, this.editor.myName, this.color));
        }

        public DevEditorUserDelta toDelta() {
            return new DevEditorUserDelta(this.editor.rl, this.line, this.pos, this.selectNextChars, this.editor.myName, this.color);
        }
    }

    public static abstract class Highlighter {
        public abstract MutableComponent highlight(int var1, ArrayList<Bi<String, MutableComponent>> var2, String var3);
    }
}

