/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DWConsoleAutoComplete;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.client.devui.DevWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DWConsole
extends DevWidget {
    final MultiLineEditBox editBox;
    private List<Component> tips = new ArrayList<Component>();

    public DWConsole() {
        DWConsoleAutoComplete.init();
        this.editBox = new MultiLineEditBox(this, this.ui().font, 0, 0, DevUI.getInstance().screenWidth / 2, 0, (Component)Component.literal((String)""), (Component)Component.empty()){

            protected void renderScrollbar(GuiGraphics context) {
                if (DevUI.instance.console.editBox.getValue().length() > 32) {
                    super.renderScrollbar(context);
                }
            }
        };
        this.editBox.setValueListener(DWConsoleAutoComplete::update);
        this.editBox.setFocused(true);
        DWConsoleAutoComplete.update(this.editBox.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLastS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        if (!this.ui().drawConsole) {
            return;
        }
        this.editBox.render(g, mouseX, mouseY, partialTick);
        DWConsole dWConsole = this;
        synchronized (dWConsole) {
            if (!this.tips.isEmpty()) {
                int n = this.tips.size();
                Objects.requireNonNull(this.ui().font);
                int l = bottom + n * 9;
                this.fill(g, left - 1, bottom, right + 1, l + 1, -1);
                this.fill(g, left, bottom, right, l, -16777216);
                int h = bottom;
                for (Component tip : this.tips) {
                    this.draw(g, left + 1, h, tip, this.ui().font);
                    Objects.requireNonNull(this.ui().font);
                    h += 9;
                }
            }
        }
    }

    @Override
    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        int w = width / 2;
        int hw = width / 4;
        Objects.requireNonNull(this.ui().font);
        int h = 9 + 6;
        int hh = h / 2;
        this.setLeft(w - hw);
        this.setTop(height / 2 - hh);
        this.setHeight(h);
        this.setWidth(w);
        this.editBox.setRectangle(w, h, this.getLeft(), this.getTop());
        this.editBox.refreshScrollAmount();
    }

    @Override
    public boolean isHovered(int mouseX, int mouseY) {
        return this.ui().drawConsole && super.isHovered(mouseX, mouseY);
    }

    @Override
    protected int offX() {
        return 0;
    }

    @Override
    protected int offY() {
        return 0;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return this.editBox.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.editBox.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        this.editBox.mouseMoved(pMouseX, pMouseY);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.editBox.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        return this.editBox.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return this.editBox.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257) {
            DWConsoleAutoComplete.execute(this.editBox.getValue());
            return true;
        }
        boolean c = this.editBox.keyPressed(pKeyCode, pScanCode, pModifiers);
        if (c) {
            DWConsoleAutoComplete.update(this.editBox.getValue());
        }
        return c;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (pCodePoint == '`') {
            this.ui().drawConsole = false;
            return true;
        }
        return this.editBox.charTyped(pCodePoint, pModifiers);
    }

    public List<Component> getTips() {
        return this.tips;
    }

    public void setEditable(boolean pEnabled) {
        if (this.editBox == null) {
            return;
        }
        this.editBox.setFocused(pEnabled);
    }
}

