/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DevWidget;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class DWTabbedView
extends DevWidget {
    private ArrayList<Tab> tabs = new ArrayList();
    Tab selected = null;
    private Tab hovered = null;
    private double scroll = 0.0;
    private int tabScrollerBottom = 0;
    private int textY = 0;

    public DWTabbedView(int left, int top, int width, int height) {
        super(left, top, width, height);
    }

    public void openAndSelect(Tab tab) {
        this.tabs.add(0, tab);
        tab.compute(this);
        tab.resize(Minecraft.getInstance(), this.ui().screenWidth, this.ui().screenHeight);
        this.selected = tab;
    }

    public void close(Tab tab) {
        if (tab.closingRequest()) {
            this.tabs.remove(tab);
            if (this.selected == tab) {
                this.selected = this.tabs.isEmpty() ? null : this.tabs.get(0);
            }
        }
    }

    @Override
    public void renderS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        g.enableScissor(left, top, right, this.tabScrollerBottom);
        g.fill(left, top, right, this.tabScrollerBottom, -15197131);
        int x = left + (int)this.scroll;
        Tab nh = null;
        boolean isBarHovered = mouseY >= top && mouseY <= this.tabScrollerBottom;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            int r = x + tab.tabWidth;
            boolean isTabHovered = isBarHovered && mouseX >= x && mouseX <= r;
            this.fill(g, x, top, r, this.tabScrollerBottom, -14999487);
            this.draw(g, x + 5, this.textY, tab.getName(), this.ui().font);
            if (this.selected == tab) {
                this.fill(g, x, top + 11, r, this.tabScrollerBottom, -13021737);
            }
            if (isTabHovered) {
                nh = tab;
            }
            x = r + 1;
        }
        g.disableScissor();
        this.hovered = nh;
        if (this.selected == null) {
            return;
        }
        this.selected.render(g, mouseX, mouseY, partialTick, this.ui().hovered == this.selected, timeHovered);
    }

    @Override
    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.tabScrollerBottom = this.getTop() + 12;
        Objects.requireNonNull(this.ui().font);
        this.textY = this.tabScrollerBottom - 2 - 9;
        for (int i = (int)this.scroll; i < this.tabs.size(); ++i) {
            this.tabs.get(i).resize(minecraft, width, height);
            this.tabs.get(i).compute(this);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseY - (double)this.offY() < 22.0) {
            this.scroll += verticalAmount * 4.0;
            return true;
        }
        if (this.selected == null) {
            return false;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void renderLastS(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        if (this.selected == null) {
            return;
        }
        this.selected.renderLastS(g, mouseX, mouseY, partialTick, isHovered, timeHovered, top, left, right, bottom);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.selected == null) {
            return false;
        }
        return this.selected.charTyped(pCodePoint, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selected == null) {
            return false;
        }
        return this.selected.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.selected == null) {
            return false;
        }
        return this.selected.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.selected == null) {
            return false;
        }
        return this.selected.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.selected == null) {
            return false;
        }
        return this.selected.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.hovered != null) {
            if (pButton == 0) {
                this.selected = this.hovered;
                return true;
            }
            if (pButton == 1) {
                if (this.hovered.closingRequest()) {
                    this.tabs.remove(this.hovered);
                }
                if (this.hovered == this.selected) {
                    Tab tab = this.selected = this.tabs.isEmpty() ? null : this.tabs.get(0);
                }
            }
        }
        if (this.selected == null) {
            return false;
        }
        return this.selected.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        if (this.selected == null) {
            return;
        }
        this.selected.mouseMoved(pMouseX, pMouseY);
    }

    public void closeAll() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.close(this.tabs.get(i));
        }
    }

    public static abstract class Tab
    extends DevWidget {
        private int tabWidth = 0;

        public Tab() {
        }

        public Tab(int left, int top, int width, int height) {
            super(left, top, width, height);
        }

        public void compute(@NotNull DWTabbedView view) {
            this.tabWidth = view.ui().font.width(this.getName()) + 10;
            this.setLeft(view.getRawLeft());
            this.setTop(view.tabScrollerBottom - this.offY());
            this.setHeight(view.getBottom() - view.tabScrollerBottom);
            this.setWidth(view.getWidth());
        }

        public abstract String getName();

        public boolean closingRequest() {
            return true;
        }
    }
}

