/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.client.devui.DevUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DevUIScreen
extends Screen {
    public DevUIScreen() {
        super((Component)Component.literal((String)"Cogwheel Engine DevUI"));
        if (DevUI.instance == null) {
            DevUI.instance = new DevUI(Minecraft.getInstance().getWindow().getScreenWidth(), Minecraft.getInstance().getWindow().getScreenHeight());
            DevUI.instance.resizeLogic(Minecraft.getInstance(), DevUI.instance.screenWidth, DevUI.instance.screenHeight);
        }
        DevUI.instance.init();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        try {
            DevUI.instance.renderLogic(g, mouseX, mouseY, partialTick, this.width, this.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        DevUI.instance.resizeLogic(minecraft, width, height);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (CogwheelHooks.getDevUIBind().matches(key, scancode)) {
            DevUI.instance.openConsole();
            return true;
        }
        if (DevUI.instance.keyPressed(key, scancode, mods)) {
            return true;
        }
        return super.keyPressed(key, scancode, mods);
    }

    public boolean keyReleased(int key, int scancode, int mods) {
        if (DevUI.instance.keyReleased(key, scancode, mods)) {
            return true;
        }
        return super.keyReleased(key, scancode, mods);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (DevUI.instance.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        super.mouseMoved(pMouseX, pMouseY);
        if (DevUI.instance == null) {
            return;
        }
        DevUI.instance.mouseMoved(pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (DevUI.instance == null) {
            return false;
        }
        return DevUI.instance.mouseClicked(pMouseX, pMouseY, pButton) || super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (DevUI.instance == null) {
            return false;
        }
        return DevUI.instance.mouseReleased(pMouseX, pMouseY, pButton) || super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (DevUI.instance == null) {
            return false;
        }
        return DevUI.instance.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY) || super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (DevUI.instance == null) {
            return false;
        }
        return DevUI.instance.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

