/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.QuestUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class QuestUIScreen
extends Screen {
    public QuestUIScreen() {
        super((Component)Component.literal((String)"Cogwheel Engine QuestUI"));
        if (QuestUI.instance != null) {
            QuestUI.instance.init();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        if (QuestUI.instance == null) {
            QuestUI.instance = new QuestUI();
            QuestUI.instance.init();
            this.resize(Minecraft.getInstance(), this.width, this.height);
        }
        try {
            QuestUI.instance.renderLogic(g, mouseX, mouseY, partialTick, this.width, this.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        QuestUI.instance.resizeLogic(minecraft, width, height);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (QuestUI.instance.keyPressed(key, scancode, mods)) {
            return true;
        }
        return super.keyPressed(key, scancode, mods);
    }

    public boolean keyReleased(int key, int scancode, int mods) {
        if (QuestUI.instance.keyReleased(key, scancode, mods)) {
            return true;
        }
        return super.keyReleased(key, scancode, mods);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (QuestUI.instance.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        super.mouseMoved(pMouseX, pMouseY);
        QuestUI.instance.mouseMoved(pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return QuestUI.instance.mouseClicked(pMouseX, pMouseY, pButton) || super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        return QuestUI.instance.mouseReleased(pMouseX, pMouseY, pButton) || super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return QuestUI.instance.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY) || super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return QuestUI.instance.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

