/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.screen;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.network.mc.DialogResponseBound;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DialogChoiceScreen
extends Screen {
    private DialogChoiceBound bound;
    private int selectedButton = -1;
    private ResourceLocation image = null;
    private float time = 0.0f;
    private int boxLeft = 0;
    private int boxRight = 0;
    private int boxTop = 0;
    private int boxBottom = 0;
    private int boxWidth = 0;
    private int boxHeight = 0;
    private int imageWidth = 0;
    private int textX = 0;
    private int textY = 0;
    private int textEnd = 0;
    private int responseX = 0;
    private int responseWidth = 0;
    private int responseEnd = 0;
    private int[] responseY = new int[0];
    private int[] responseH = new int[0];

    public DialogChoiceScreen(DialogChoiceBound bound) {
        super((Component)Component.translatable((String)"ui.storyanvil_cogwheel.dialog_choice"));
        this.bound = bound;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void render(@NotNull GuiGraphics DrawContext, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.boxLeft == 0) {
            this.resize(Minecraft.getInstance(), this.width, this.height);
        }
        this.selectedButton = -1;
        Font font = Minecraft.getInstance().font;
        DrawContext.fill(this.boxLeft, this.boxTop, this.boxRight, this.boxBottom, -939524096);
        DrawContext.blitSprite(t -> RenderType.gui(), this.image, this.boxLeft, this.boxBottom - this.imageWidth, this.imageWidth, this.imageWidth, 0, 0, 100, 100);
        DrawContext.drawString(font, this.bound.npcName(), this.textX, this.textY, 0x55FF55, false);
        this.time += pPartialTick;
        Component component = Component.nullToEmpty((String)this.bound.request().substring(0, Math.min((int)this.time, this.bound.request().length())));
        Objects.requireNonNull(font);
        DrawContext.drawWordWrap(font, (FormattedText)component, this.textX, this.textY + 9 + 5, this.textEnd, 0xFFFFFF, false);
        for (int i = 0; i < this.bound.options().size(); ++i) {
            String o = this.bound.options().get(i);
            int left = this.responseX - 1;
            int top = this.responseY[i] - 1;
            int bottom = this.responseY[i] + this.responseH[i];
            boolean isHovered = StoryUtils.isHovering(pMouseX, pMouseY, left, this.responseEnd, top, bottom);
            if (isHovered) {
                this.selectedButton = i;
            }
            DrawContext.fill(left, top, this.responseEnd, bottom, isHovered ? -936892376 : -939524096);
            DrawContext.drawWordWrap(font, (FormattedText)Component.nullToEmpty((String)o), this.responseX, this.responseY[i], this.responseWidth, 0xFFFFFF, false);
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        Font font = minecraft.font;
        this.boxWidth = Mth.clamp((int)((int)((float)width / 100.0f * 70.0f)), (int)100, (int)350);
        this.boxHeight = Mth.clamp((int)((int)((float)height / 100.0f * 30.0f)), (int)50, (int)150);
        this.boxTop = height / 4 * 3 - this.boxHeight / 2;
        this.boxLeft = width / 2 - this.boxWidth / 2;
        this.boxRight = this.boxLeft + this.boxWidth;
        this.boxBottom = this.boxTop + this.boxHeight;
        this.imageWidth = Math.max(this.boxWidth / 3, this.boxHeight);
        this.textX = this.boxLeft + this.imageWidth + 15;
        this.textY = this.boxTop + 5;
        this.textEnd = this.boxWidth - this.imageWidth - 30;
        this.image = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)("textures/dialog/" + this.bound.texture() + ".png"));
        this.responseY = new int[this.bound.options().size()];
        this.responseH = new int[this.bound.options().size()];
        this.responseX = this.boxRight - 25;
        this.responseWidth = this.boxWidth / 3;
        int baseY = this.boxTop - 30;
        this.responseEnd = this.responseX + this.responseWidth;
        for (int i = 0; i < this.bound.options().size(); ++i) {
            String o = this.bound.options().get(i);
            int lines = font.wordWrapHeight((FormattedText)Component.nullToEmpty((String)o), this.responseWidth) / 9;
            Objects.requireNonNull(font);
            int h = lines * 9;
            this.responseY[i] = baseY - h;
            this.responseH[i] = h;
            baseY = this.responseY[i] - 10;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.selectedButton == -1) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        CogwheelHooks.sendPacketToServer(new DialogResponseBound(this.bound.dialogId(), this.selectedButton));
        return true;
    }
}

