/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBldr;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class StoryCodecs {
    public static final StoryCodec<Boolean> BOOLEAN = new StoryCodec<Boolean>((a, b) -> b.writeBoolean(a.booleanValue()), FriendlyByteBuf::readBoolean);
    public static final StoryCodec<Byte> BYTE = new StoryCodec<Byte>((a, b) -> b.writeByte((int)a.byteValue()), FriendlyByteBuf::readByte);
    public static final StoryCodec<Integer> INTEGER = new StoryCodec<Integer>((a, b) -> b.writeInt(a.intValue()), FriendlyByteBuf::readInt);
    public static final StoryCodec<Long> LONG = new StoryCodec<Long>((a, b) -> b.writeLong(a.longValue()), FriendlyByteBuf::readLong);
    public static final StoryCodec<Float> FLOAT = new StoryCodec<Float>((a, b) -> b.writeFloat(a.floatValue()), FriendlyByteBuf::readFloat);
    public static final StoryCodec<Double> DOUBLE = new StoryCodec<Double>((a, b) -> b.writeDouble(a.doubleValue()), FriendlyByteBuf::readDouble);
    public static final StoryCodec<String> STRING = new StoryCodec<String>((a, b) -> StoryUtils.encodeString(b, a), StoryUtils::decodeString);
    public static final StoryCodec<JsonObject> JSON = new StoryCodec<JsonObject>((a, b) -> StoryUtils.encodeString(b, a.toString()), b -> JsonParser.parseString((String)StoryUtils.decodeString(b)).getAsJsonObject());
    public static final StoryCodec<ResourceLocation> RESOURCE_LOC = new StoryCodec<ResourceLocation>((a, b) -> {
        StoryUtils.encodeString(b, a.getNamespace());
        StoryUtils.encodeString(b, a.getPath());
    }, b -> ResourceLocation.fromNamespaceAndPath((String)StoryUtils.decodeString(b), (String)StoryUtils.decodeString(b)));
    public static final StoryCodec<ResourceLocation> IDENTIFIER = RESOURCE_LOC;
    public static final StoryCodec<CameraPos> CAMERA_POS = new StoryCodec<CameraPos>(CameraPos::encode, CameraPos::decode);
    public static final StoryCodec<Item> ITEM = StoryCodecs.getRegistryCodec(BuiltInRegistries.ITEM);
    public static final StoryCodec<Block> BLOCK = StoryCodecs.getRegistryCodec(BuiltInRegistries.BLOCK);
    public static final StoryCodec<EntityType<?>> ENTITY_TYPE = StoryCodecs.getRegistryCodec(BuiltInRegistries.ENTITY_TYPE);
    public static final StoryCodec<Attribute> ATTRIBUTE = StoryCodecs.getRegistryCodec(BuiltInRegistries.ATTRIBUTE);
    public static final StoryCodec<Component> TEXT = StoryCodecBldr.build(StoryCodecBldr.Prop(t -> Component.Serializer.toJson((Component)t, (HolderLookup.Provider)Minecraft.getInstance().getConnection().registryAccess()), STRING), s -> Component.Serializer.fromJson((String)s, (HolderLookup.Provider)Minecraft.getInstance().getConnection().registryAccess()));

    public static <T> StoryCodec<List<T>> getListCodec(StoryCodec<T> codec) {
        return new StoryCodec<List<T>>((ts, buf) -> {
            buf.writeInt(ts.size());
            for (int i = 0; i < ts.size(); ++i) {
                codec.encode((Object)ts.get(i), (FriendlyByteBuf)buf);
            }
        }, buf -> {
            int l = buf.readInt();
            ArrayList q = new ArrayList(l);
            for (int i = 0; i < l; ++i) {
                q.add(codec.decode((FriendlyByteBuf)buf));
            }
            return q;
        });
    }

    public static <T> StoryCodec<T> getRegistryCodec(Registry<T> registry) {
        return StoryCodecBldr.build(StoryCodecBldr.String(o -> String.valueOf(registry.getKey(o))), s -> registry.getValue(ResourceLocation.parse((String)s)));
    }

    public static <T> StoryCodec<T> getNullableCodec(StoryCodec<T> nonNullableCodec) {
        return new StoryCodec<Object>((t, buf) -> {
            if (t == null) {
                buf.writeBoolean(false);
                return;
            }
            buf.writeBoolean(true);
            nonNullableCodec.encode((Object)t, (FriendlyByteBuf)buf);
        }, buf -> {
            if (buf.readBoolean()) {
                return nonNullableCodec.decode((FriendlyByteBuf)buf);
            }
            return null;
        });
    }
}

