/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.DialogTarget;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryActionQueue;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryChatter;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryModel;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNameHolder;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNavigator;
import com.storyanvil.cogwheel.infrastructure.abilities.StorySkinHolder;
import com.storyanvil.cogwheel.infrastructure.actions.AnimationAction;
import com.storyanvil.cogwheel.infrastructure.actions.PathfindAction;
import com.storyanvil.cogwheel.infrastructure.actions.WaitForLabelAction;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogEventCallback;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.mixinAccess.IStoryEntity;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevOpenViewer;
import com.storyanvil.cogwheel.network.devui.inspector.InspectableEntity;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NPC
extends Animal
implements StoryActionQueue<NPC>,
StoryChatter,
StoryNameHolder,
StorySkinHolder,
StoryNavigator,
ObjectMonitor.IMonitored,
CGPM,
StoryAnimator,
GeoEntity,
StoryModel,
DialogTarget,
InspectableEntity {
    private static final ObjectMonitor<NPC> MONITOR = new ObjectMonitor();
    private final Queue<StoryAction<? extends NPC>> actionQueue = new ArrayDeque<StoryAction<? extends NPC>>();
    private StoryAction current;
    private CogEntity me;
    private long lastInteraction = 0L;
    @Api.PlatformTool
    public ResourceLocation platformModel = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"geo/npc.geo.json");
    @Api.PlatformTool
    public ResourceLocation platformTexture = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"textures/entity/npc/denisjava.png");
    private static final EasyPropManager MANAGER = new EasyPropManager("npc", NPC::registerProps);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.npc.walk");
    private RawAnimation customAnimation = null;

    public NPC(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        MONITOR.register(this);
        if (!pLevel.isClientSide) {
            this.me = new CogEntity((Entity)this);
            this.setSkin(DataStorage.getString((Entity)this, "skin", "test"));
            this.setCustomName(DataStorage.getString((Entity)this, "name", "NPC"));
            this.setStoryModelID(DataStorage.getString((Entity)this, "model", "npc"));
            this.storyEntity().storyEntity$putString("rightclick", this.storyEntity().storyEntity$getString("rightclick", ""));
            this.storyEntity().storyEntity$putString("leftclick", this.storyEntity().storyEntity$getString("leftclick", ""));
        }
    }

    public IStoryEntity storyEntity() {
        return (IStoryEntity)((Object)this);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player plr, @NotNull InteractionHand hand) {
        String action = this.storyEntity().storyEntity$getString("rigthclick", "");
        if (plr instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)plr;
            if (!action.isEmpty()) {
                long time = System.currentTimeMillis();
                if (time - this.lastInteraction < 250L) {
                    return InteractionResult.FAIL;
                }
                this.lastInteraction = time;
                CogScriptEnvironment.dispatchScriptGlobal(action, new ScriptStorage().append("internal_callback", new CogEventCallback()).append("event_player", new CogPlayer(new WeakReference<ServerPlayer>(player))).append("event_npc", this));
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(plr, hand);
    }

    public void interact(ServerPlayer plr) {
        String action = this.storyEntity().storyEntity$getString("leftclick", "");
        if (action.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastInteraction < 250L) {
            return;
        }
        this.lastInteraction = time;
        CogScriptEnvironment.dispatchScriptGlobal(action, new ScriptStorage().append("internal_callback", new CogEventCallback()).append("event_player", new CogPlayer(new WeakReference<ServerPlayer>(plr))).append("event_npc", this));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.current != null) {
                if (this.current.freeToGo(this)) {
                    this.current = null;
                }
            } else {
                if (this.actionQueue.isEmpty()) {
                    return;
                }
                this.current = this.actionQueue.remove();
                this.current.proceed(this);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    @Nullable
    public Component getCustomName() {
        return Component.literal((String)this.getCogName());
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getCogName() {
        return this.storyEntity().storyEntity$getString("name", "NPC");
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setCogName(String name) {
        this.storyEntity().storyEntity$putString("name", name);
    }

    @Api.Stable(since="2.0.0")
    public void setCustomName(@Nullable Component pName) {
        this.storyEntity().storyEntity$putString("name", pName == null ? "" : pName.getString());
    }

    @Api.Stable(since="2.0.0")
    public void setCustomName(@Nullable String pName) {
        this.storyEntity().storyEntity$putString("name", pName == null ? "" : pName);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    public void checkDespawn() {
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getSkin() {
        return this.storyEntity().storyEntity$getString("skin", "test");
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setSkin(String skin) {
        this.storyEntity().storyEntity$putString("skin", skin);
        this.platformTexture = ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)("textures/entity/npc/" + this.getSkin() + ".png"));
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void chat(String text) {
        if (!this.level().isClientSide) {
            MutableComponent c = Component.literal((String)("[" + this.getCogName() + "] " + text));
            for (ServerPlayer player : ((ServerLevel)this.level()).players()) {
                player.sendSystemMessage((Component)c);
            }
        }
    }

    @Override
    @Api.Stable(since="2.0.0")
    public synchronized <R> void addStoryAction(StoryAction<R> action) {
        this.actionQueue.add(action);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void reportState(StringBuilder sb) {
        for (StoryAction storyAction : this.actionQueue) {
            sb.append(storyAction.toString());
        }
        sb.append(">").append(this.current.toString());
        sb.append(" | ").append(this);
    }

    private static void registerProps(EasyPropManager manager) {
        manager.reg("setName", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setCogName(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getName", (name, args, script, o) -> new CogString(((NPC)o).getCogName()));
        manager.reg("setSkin", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setSkin(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getSkin", (name, args, script, o) -> new CogString(((NPC)o).getSkin()));
        manager.reg("setModel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setStoryModelID(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getModel", (name, args, script, o) -> new CogString(((NPC)o).getStoryModelID()));
        manager.reg("chat", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.chat(args.get(0).convertToString());
                }
            });
        });
        manager.reg("pathfind", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new PathfindAction(new BlockPos(args.requireInt(0), args.requireInt(1), args.requireInt(2))));
        });
        manager.reg("waitForLabel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            if (args.size() == 1) {
                return npc.addChained(new WaitForLabelAction(args.getString(0)));
            }
            return npc.addChained(new WaitForLabelAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("animation", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new AnimationAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("dialogChoices", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            final Component[] Texts = new Component[args.size()];
            for (int i = 0; i < Texts.length; ++i) {
                Texts[i] = Component.literal((String)("[" + (i + 1) + "] ")).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)).append((Component)Component.literal((String)args.getString(i)).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/@storyclient dialog " + i + " " + dialogID)).withColor(ChatFormatting.WHITE)));
            }
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> StoryUtils.sendGlobalMessage(event, Texts));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        script.put(variable, new CogInteger((int)response));
                        script.lineDispatcher();
                    }));
                }
            });
        });
        manager.reg("dialogBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = new DialogBound(args.getString(0), npc.getCogName(), args.getString(1));
            npc.addStoryAction(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelHooks.sendPacketToEveryone(bound);
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(e -> {
                        script.put(variable, CGPM.nullManager);
                        CogwheelHooks.sendPacketToEveryone(new DialogBound());
                        if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                            CogwheelHooks.sendPacketToEveryone(new AnimationBound(npc.getAnimatorID(), "null"));
                        }
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }, args.requireInt(2));
                }
            });
        });
        manager.reg("dialogNonBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = new DialogBound(args.getString(0), npc.getCogName(), args.getString(1));
            return npc.addChained(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelHooks.sendPacketToEveryone(bound);
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }

                @Override
                public void onEnding() {
                    CogwheelHooks.sendPacketToEveryone(new DialogBound());
                    if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                        CogwheelHooks.sendPacketToEveryone(new AnimationBound(npc.getAnimatorID(), "null"));
                    }
                }
            });
        });
        manager.reg("dialogChoiceUI", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            int optionsLength = args.size() - 1;
            String[] options = new String[optionsLength - 1];
            for (int i = 0; i < optionsLength - 1; ++i) {
                options[i] = args.getString(i + 1);
            }
            final DialogChoiceBound bound = new DialogChoiceBound(dialogID, args.getString(0), options, npc.getCogName(), args.getString(optionsLength));
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> CogwheelHooks.sendPacketToEveryone(bound));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(new DialogChoiceBound()));
                        script.put(variable, new CogInteger((int)response));
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }));
                }
            });
        });
        manager.reg("setRightClick", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> npc.storyEntity().storyEntity$putString("rightclick", args.getString(0)));
            return null;
        });
        manager.reg("setLeftClick", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> npc.storyEntity().storyEntity$putString("leftclick", args.getString(0)));
            return null;
        });
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean hasOwnProperty(String name) {
        if (this.me.hasOwnProperty(name)) {
            return true;
        }
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Api.Stable(since="2.0.0")
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        if (this.me.hasOwnProperty(name)) {
            return this.me.getProperty(name, args, script);
        }
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean equalsTo(CGPM o) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walking", this::walkAnim));
    }

    protected <E extends NPC> PlayState walkAnim(AnimationState<E> event) {
        if (this.customAnimation != null) {
            return event.setAndContinue(this.customAnimation);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public String getAnimatorID() {
        return this.getStringUUID();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void pushAnimation(String name) {
        if (name.equals("null")) {
            this.customAnimation = null;
            return;
        }
        this.customAnimation = RawAnimation.begin().thenLoop(name);
    }

    @Override
    public String getStoryModelID() {
        return this.storyEntity().storyEntity$getString("model", "npc");
    }

    @Override
    public void setStoryModelID(String id) {
        this.storyEntity().storyEntity$putString("model", id);
    }

    @Override
    public void d$say(String text, String texture, int ticks, final Runnable trigger) {
        final DialogBound bound = new DialogBound(text, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Ticking<NPC>(ticks){

            @Override
            public void proceed(NPC myself) {
                CogwheelHooks.sendPacketToEveryone(bound);
                CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
            }

            @Override
            public void onEnding() {
                CogwheelHooks.sendPacketToEveryone(new DialogBound());
                if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(NPC.this.getAnimatorID(), "null"));
                }
                CogwheelExecutor.schedule(trigger);
            }
        });
    }

    @Override
    public void d$ask(String text, String texture, List<String> options, Consumer<Integer> acceptor) {
        String dialogID = UUID.randomUUID().toString();
        final DialogChoiceBound bound = new DialogChoiceBound(dialogID, text, options, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Instant<NPC>(this){

            @Override
            public void proceed(NPC myself) {
                CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(bound));
            }
        });
        CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(new DialogChoiceBound()));
            acceptor.accept((Integer)response);
        }));
    }

    @Override
    public String d$name() {
        return this.getCogName();
    }

    @Override
    public synchronized boolean tryToInspect(@NotNull ServerLevel level, @NotNull ServerPlayer player) {
        JsonObject obj = new JsonObject();
        obj.addProperty("uuid", this.getStringUUID());
        obj.addProperty("animatorID", this.getAnimatorID());
        obj.addProperty("skinID", this.getSkin());
        obj.addProperty("modelID", this.getStoryModelID());
        JsonArray array = new JsonArray();
        for (StoryAction storyAction : this.actionQueue) {
            array.add((JsonElement)storyAction.toJSON());
        }
        obj.add("storyActions", (JsonElement)array);
        if (this.current != null) {
            obj.add("currentStoryAction", (JsonElement)this.current.toJSON());
        } else {
            obj.add("currentStoryAction", null);
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("    ");
            jsonWriter.setSerializeNulls(true);
            Streams.write((JsonElement)obj, (JsonWriter)jsonWriter);
            CogwheelNetwork.sendFromServer(player, new DevOpenViewer("npc.json", stringWriter.toString()));
            return true;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }
}

