/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.actions;

import com.google.gson.JsonObject;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNavigator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public class PathfindAction
extends StoryAction<StoryNavigator> {
    private final BlockPos target;

    public PathfindAction(BlockPos target) {
        this.target = target;
    }

    @Override
    public void proceed(@NotNull StoryNavigator myself) {
        PathNavigation navigation = myself.getNavigation();
        Path path = navigation.createPath((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ(), 0);
        myself.getNavigation().moveTo(path, 2.0);
    }

    @Override
    public boolean freeToGo(@NotNull StoryNavigator myself) {
        boolean done;
        boolean bl = done = !myself.getNavigation().isDone();
        if (done) {
            this.hitLabel();
        }
        return done;
    }

    @Override
    protected void toJSON(JsonObject obj) {
        super.toJSON(obj);
        obj.addProperty("x", (Number)this.target.getX());
        obj.addProperty("y", (Number)this.target.getY());
        obj.addProperty("z", (Number)this.target.getZ());
    }
}

