/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.ForEachManager;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogArray
implements CGPM,
ForEachManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("array", CogArray::registerProps);
    private ArrayList<CGPM> list;

    @Contract(pure=true)
    private CogArray(ArrayList<CGPM> list) {
        this.list = list;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("get", (name, args, script, o) -> {
            CogArray array = (CogArray)o;
            return array.list.get(args.requireInt(0));
        });
        manager.reg("remove", (name, args, script, o) -> {
            CogArray array = (CogArray)o;
            array.list.remove(args.requireInt(0));
            return null;
        });
        manager.reg("add", (name, args, script, o) -> {
            CogArray array = (CogArray)o;
            array.list.add(args.get(0));
            return null;
        });
        manager.reg("size", (name, args, script, o) -> {
            CogArray array = (CogArray)o;
            return new CogInteger(array.list.size());
        });
    }

    @Override
    public boolean hasOwnProperty(@NotNull String name) {
        if (name.startsWith("$")) {
            return true;
        }
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(@NotNull String name, ArgumentData args, DispatchedScript script) {
        if (name.startsWith("$")) {
            String sub = name.substring(1);
            for (CGPM t : this.list) {
                if (t.hasOwnProperty(sub)) {
                    t.getProperty(sub, args, script);
                    continue;
                }
                throw new RuntimeException("Array element does not have property " + sub);
            }
            return null;
        }
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public String convertToString() {
        return this.list.toString();
    }

    @Override
    public boolean equalsTo(CGPM o) {
        return false;
    }

    @Contract(value="_ -> new", pure=true)
    @Api.Stable(since="2.0.0")
    @NotNull
    public static CogArray getInstance(ArrayList<CGPM> t) {
        return new CogArray(t);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static <Q extends CGPM> CogArray getInstance(List<Q> t) {
        return new CogArray(new ArrayList<CGPM>(t));
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static <Q extends CGPM> CogArray getInstance(@NotNull Iterable<Q> t) {
        ArrayList<CGPM> list = new ArrayList<CGPM>();
        for (CGPM q : t) {
            list.add(q);
        }
        return new CogArray(list);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static <Q extends CGPM> CogArray getInstance(Q q) {
        ArrayList<CGPM> list = new ArrayList<CGPM>();
        list.add(q);
        return new CogArray(list);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static CogArray convertInstance(@NotNull Iterable<String> s) {
        ArrayList<CGPM> list = new ArrayList<CGPM>();
        for (String q : s) {
            list.add(new CogString(q));
        }
        return new CogArray(list);
    }

    @Override
    public Object createForEach(DispatchedScript script) {
        return 0;
    }

    @Override
    public Bi<CGPM, Object> getForEach(Object track) {
        int i = (Integer)track;
        if (this.list.size() <= i) {
            return null;
        }
        return new Bi<CGPM, Object>(this.list.get(i), i + 1);
    }
}

