/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CogDouble
implements CGPM,
CogPrimalType {
    private static final EasyPropManager MANAGER = new EasyPropManager("double", CogDouble::registerProps);
    private double value;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("add", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            i.value += args.requireDouble(0);
            return i;
        });
        manager.reg("subtract", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            i.value -= args.requireDouble(0);
            return i;
        });
        manager.reg("multiply", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            i.value *= args.requireDouble(0);
            return i;
        });
        manager.reg("divide", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            i.value /= args.requireDouble(0);
            return i;
        });
        manager.reg("clamp", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            double min = args.requireDouble(0);
            double max = args.requireDouble(1);
            if (i.value < min) {
                i.value = min;
            }
            if (i.value > max) {
                i.value = max;
            }
            return i;
        });
        manager.reg("abs", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            i.value = Math.abs(i.value);
            return i;
        });
        manager.reg("toInt", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            return new CogInteger(Math.toIntExact(Math.round(i.value)));
        });
        manager.reg("clone", (name, args, script, o) -> {
            CogDouble i = (CogDouble)o;
            return new CogDouble(i.value);
        });
    }

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogDouble(double value) {
        this.value = value;
    }

    @Api.Stable(since="2.0.0")
    public CogDouble(String value) {
        this(Double.parseDouble(value));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogDouble) {
            CogDouble other = (CogDouble)o;
            return other.value == this.value;
        }
        return false;
    }

    @Contract(pure=true)
    public double getValue() {
        return this.value;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String convertToString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    @Contract(pure=true)
    public byte getPrimalID() {
        return 40;
    }

    @Override
    public void putPrimal(@NotNull CompoundTag tag, String key) {
        tag.putDouble(key, this.value);
    }

    @Override
    public Object getObjValue() {
        return this.value;
    }
}

