/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogEntity
implements CGPM {
    private static final EasyPropManager MANAGER = new EasyPropManager("entity", CogEntity::registerProps);
    private final WeakReference<Entity> e;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("getEntityType", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(BuiltInRegistries.ENTITY_TYPE.getKey((Object)CogEntity.unsafeEntity(e).getType()).toString());
        });
        manager.reg("getUUID", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(CogEntity.unsafeEntity(e).getStringUUID());
        });
        manager.reg("toEntity", (name, args, script, o) -> (CogEntity)o);
        manager.reg("teleport", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).teleportTo(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            return e;
        });
        manager.reg("turn", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).forceSetRotation((float)args.requireDoubleOrInt(0), (float)args.requireDoubleOrInt(1));
            return e;
        });
        manager.reg("teleport2", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).teleportTo(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            CogEntity.unsafeEntity(e).forceSetRotation((float)args.requireDoubleOrInt(3), (float)args.requireDoubleOrInt(4));
            return e;
        });
        manager.reg("getX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).getX());
        });
        manager.reg("getY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).getY());
        });
        manager.reg("getZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).getZ());
        });
        manager.reg("getBlockX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).getBlockX());
        });
        manager.reg("getBlockY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).getBlockY());
        });
        manager.reg("getBlockZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).getBlockZ());
        });
        manager.reg("kill", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).kill((ServerLevel)CogEntity.unsafeEntity(e).level());
            e.e.clear();
            return null;
        });
        manager.reg("hasTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).getTags().contains(args.getString(0)));
        });
        manager.reg("addTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).addTag(args.getString(0)));
        });
        manager.reg("removeTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).removeTag(args.getString(0)));
        });
        manager.reg("getTags", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogArray.convertInstance(CogEntity.unsafeEntity(e).getTags());
        });
        manager.reg("putInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setInt(CogEntity.unsafeEntity(e), args.getString(0), args.requireInt(1));
            return e;
        });
        manager.reg("getInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(DataStorage.getInt(CogEntity.unsafeEntity(e), args.getString(0), 0));
        });
        manager.reg("putString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(CogEntity.unsafeEntity(e), args.getString(0), args.getString(1));
            return e;
        });
        manager.reg("getString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(DataStorage.getString(CogEntity.unsafeEntity(e), args.getString(0), ""));
        });
        manager.reg("putBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setBoolean(CogEntity.unsafeEntity(e), args.getString(0), args.requireBoolean(1));
            return e;
        });
        manager.reg("getBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(DataStorage.getBoolean(CogEntity.unsafeEntity(e), args.getString(0), false));
        });
        manager.reg("putLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(CogEntity.unsafeEntity(e), args.getString(0), String.valueOf(args.requireLong(1)));
            return e;
        });
        manager.reg("getLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogLong(DataStorage.getString(CogEntity.unsafeEntity(e), args.getString(0), "0"));
        });
        manager.reg("getDisplayName", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(Objects.requireNonNull(Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded"), "entity got unloaded").getDisplayName().getString());
        });
    }

    @NotNull
    private static Entity unsafeEntity(CogEntity e) {
        return Objects.requireNonNull((Entity)e.e.get(), "entity got unloaded");
    }

    @Api.Experimental(since="2.0.0")
    public CogEntity(WeakReference<Entity> entity) {
        this.e = entity;
    }

    @Api.Stable(since="2.0.0")
    public CogEntity(Entity entity) {
        this(new WeakReference<Entity>(entity));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogEntity) {
            CogEntity other = (CogEntity)o;
            return this.e.get() == other.e.get();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.e);
    }
}

