/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.entity.NPC;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogHashmap;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogInvoker;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogRange;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.network.mc.AnimationDataBound;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogMaster
implements CGPM {
    private static final EasyPropManager MANAGER = new EasyPropManager("master", CogMaster::register);
    private static CogMaster instance = null;
    private static Random random = new Random();

    @Api.Experimental(since="2.0.0")
    public static CogMaster getInstance() {
        if (instance == null) {
            instance = new CogMaster();
        }
        return instance;
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        return o instanceof CogMaster;
    }

    private static void register(@NotNull EasyPropManager manager) {
        manager.reg("log", (name, args, script, o) -> {
            CogwheelExecutor.log.info("{}: {}", (Object)script.getScriptName(), (Object)args.getString(0));
            return null;
        });
        manager.reg("debug", (name, args, script, o) -> {
            if (CogwheelConfig.isDevEnvironment()) {
                CogwheelExecutor.log.info("[DBG] {}: {}", (Object)script.getScriptName(), (Object)args.getString(0));
            }
            return null;
        });
        manager.reg("isDebugging", (name, args, script, o) -> CogBool.getInstance(CogwheelConfig.isDevEnvironment()));
        manager.reg("getTaggedNPC", (name, args, script, o) -> {
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(world -> 1.getNPCByTag(world, variable, args.getString(0), script));
                }

                public static void getNPCByTag(@NotNull ServerLevel level, String variable, String tag, @NotNull DispatchedScript notify) {
                    NPC[] npc = new NPC[]{null};
                    level.getEntities((EntityTypeTest)new EntityTypeTest<Entity, NPC>(){

                        @Nullable
                        public NPC downcast(@NotNull Entity entity) {
                            if (entity instanceof NPC) {
                                NPC npc = (NPC)entity;
                                return npc;
                            }
                            return null;
                        }

                        @NotNull
                        public Class<? extends Entity> getBaseClass() {
                            return NPC.class;
                        }
                    }, npc1 -> {
                        if (npc1.getTags().contains(tag)) {
                            npc[0] = npc1;
                            return false;
                        }
                        return true;
                    });
                    notify.put(variable, npc[0]);
                    if (npc[0] == null) {
                        CogwheelExecutor.log.info("{}: No NPC with tag {} found!", (Object)notify.getScriptName(), (Object)tag);
                    }
                    CogwheelExecutor.schedule(notify::lineDispatcher);
                }
            });
        });
        manager.reg("str", (name, args, script, o) -> args.getCogString(0));
        manager.reg("int", (name, args, script, o) -> new CogInteger(args.requireInt(0)));
        manager.reg("double", (name, args, script, o) -> new CogDouble(args.requireDouble(0)));
        manager.reg("toInt", (name, args, script, o) -> new CogInteger(args.getString(0)));
        manager.reg("toDouble", (name, args, script, o) -> new CogDouble(args.getString(0)));
        manager.reg("true", (name, args, script, o) -> CogBool.TRUE);
        manager.reg("false", (name, args, script, o) -> CogBool.FALSE);
        manager.reg("getLevel", (name, args, script, o) -> EventBus.getStoryLevel());
        manager.reg("disposeVariable", (name, args, script, o) -> {
            script.getStorage().remove(args.getString(0));
            return null;
        });
        manager.reg("getEvent", (name, args, script, o) -> script.get("internal_callback"));
        manager.reg("randomInt", (name, args, script, o) -> new CogInteger(random.nextInt(args.requireInt(0), args.requireInt(1))));
        manager.reg("createList", (name, args, script, o) -> CogArray.getInstance(args.get(0)));
        manager.reg("dispatchScript", (name, args, script, o) -> {
            if (args.size() == 1) {
                script.getEnvironment().dispatchScript(args.getString(0));
            } else {
                script.getEnvironment().dispatchScript(args.getString(0), ((CogHashmap)args.get(1)).getValue());
            }
            return null;
        });
        manager.reg("scriptInvoker", (name, args, script, o) -> CogInvoker.scriptInvoker(ResourceLocation.tryParse((String)args.getString(0))));
        manager.reg("scheduleScript", (name, args, script, o) -> {
            CogwheelExecutor.schedule(() -> script.getEnvironment().dispatchScript(args.getString(0)), args.requireInt(1));
            return null;
        });
        manager.reg("scheduleThis", (name, args, script, o) -> {
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.schedule(script::lineDispatcher, args.requireInt(0));
                }
            });
        });
        manager.reg("dispatchScriptGlobal", (name, args, script, o) -> {
            if (args.size() == 1) {
                CogScriptEnvironment.dispatchScriptGlobal(args.getString(0));
            } else {
                CogScriptEnvironment.dispatchScriptGlobal(args.getString(0), ((CogHashmap)args.get(1)).getValue());
            }
            return null;
        });
        manager.reg("waitForStoryActionLabel", (name, args, script, o) -> {
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    EventBus.register(args.getString(0), (label, host) -> CogwheelExecutor.schedule(script::lineDispatcher));
                }
            });
        });
        manager.reg("addAnimationSource", (name, args, script, o) -> {
            ResourceLocation loc = ResourceLocation.tryParse((String)(args.getString(0) + ".json"));
            String m = loc.toString();
            boolean found = false;
            for (ResourceLocation r : EventBus.serverSideAnimations) {
                if (!r.toString().equals(m)) continue;
                found = true;
                break;
            }
            if (!found) {
                EventBus.serverSideAnimations.add(loc);
                StringBuilder sb = new StringBuilder();
                boolean a = true;
                for (ResourceLocation locc : EventBus.serverSideAnimations) {
                    if (a) {
                        a = false;
                    } else {
                        sb.append("|");
                    }
                    sb.append(locc.toString());
                }
                CogwheelHooks.sendPacketToEveryone(new AnimationDataBound(sb.toString()));
            }
            return null;
        });
        manager.reg("removeAnimationSource", (name, args, script, o) -> {
            ResourceLocation loc = ResourceLocation.tryParse((String)(args.getString(0) + ".json"));
            String m = loc.toString();
            boolean found = false;
            for (int i = 0; i < EventBus.serverSideAnimations.size(); ++i) {
                ResourceLocation bad = EventBus.serverSideAnimations.get(i);
                if (!bad.toString().equals(m)) continue;
                EventBus.serverSideAnimations.remove(i);
                found = true;
                break;
            }
            if (found) {
                StringBuilder sb = new StringBuilder();
                boolean a = true;
                for (ResourceLocation locc : EventBus.serverSideAnimations) {
                    if (a) {
                        a = false;
                    } else {
                        sb.append("|");
                    }
                    sb.append(locc.toString());
                }
                CogwheelHooks.sendPacketToEveryone(new AnimationDataBound(sb.toString()));
            }
            return null;
        });
        manager.reg("clearAnimationSources", (name, args, script, o) -> {
            EventBus.serverSideAnimations.clear();
            CogwheelHooks.sendPacketToEveryone(new AnimationDataBound(""));
            return null;
        });
        manager.reg("createHashmap", (name, args, script, o) -> new CogHashmap());
        manager.reg("time", (name, args, script, o) -> new CogLong(System.currentTimeMillis() - script.getEnvironment().getCreationTime()));
        manager.reg("dump", (name, args, script, o) -> {
            for (Map.Entry entry : script.getStorage().entrySet()) {
                CogwheelExecutor.log.info("{}: >{}< = {}", new Object[]{script.getScriptName(), entry.getKey(), ((CGPM)entry.getValue()).convertToString()});
            }
            return null;
        });
        manager.reg("range", (name, args, script, o) -> new CogRange(0, args.requireInt(0)));
        manager.reg("range2", (name, args, script, o) -> new CogRange(args.requireInt(0), args.requireInt(1)));
        manager.reg("choose", (name, args, script, o) -> {
            boolean b = args.requireBoolean(0);
            return b ? args.get(1) : args.get(2);
        });
        manager.reg("map", (name, args, script, o) -> {
            int b = args.requireInt(0);
            return args.get(b + 1);
        });
        manager.reg("executeCommand", (name, args, script, o) -> {
            CogwheelHooks.executeCommand(args.getString(0));
            return null;
        });
    }

    @Override
    public String convertToString() {
        return "Cogwheel Object";
    }
}

