/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.network.mc.CameraForceBound;
import com.storyanvil.cogwheel.network.mc.CameraTransitionBound;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogPlayer
extends CogEntity
implements CGPM {
    private static final EasyPropManager MANAGER = new EasyPropManager("player", CogPlayer::registerProps);
    private WeakReference<ServerPlayer> player;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("sendMessage", (name, args, script, o) -> {
            CogPlayer p = (CogPlayer)o;
            if (p.player.refersTo(null)) {
                throw new RuntimeException("Player got unloaded");
            }
            ((ServerPlayer)p.player.get()).sendSystemMessage((Component)Component.literal((String)args.getString(0)));
            return null;
        });
        manager.reg("toEntity", (name, args, script, o) -> new CogEntity((Entity)((CogPlayer)o).player.get()));
        manager.reg("takeItem", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            ServerPlayer p = Objects.requireNonNull((ServerPlayer)pll.player.get(), "player got unloaded");
            p.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
            return null;
        });
        manager.reg("setCamera", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            CogwheelHooks.sendPacket(new CameraForceBound(new CameraPos(new Vec3(args.requireDouble(0), args.requireDouble(1), args.requireDouble(2)), (float)args.requireDouble(3), (float)args.requireDouble(4))), (ServerPlayer)pll.player.get());
            return null;
        });
        manager.reg("unsetCamera", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            CogwheelHooks.sendPacket(new CameraForceBound(null), (ServerPlayer)pll.player.get());
            return null;
        });
        manager.reg("transCamera", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            CogwheelHooks.sendPacket(new CameraTransitionBound(new CameraPos(new Vec3(args.requireDouble(0), args.requireDouble(1), args.requireDouble(2)), (float)args.requireDouble(3), (float)args.requireDouble(4)), new CameraPos(new Vec3(args.requireDouble(5), args.requireDouble(6), args.requireDouble(7)), (float)args.requireDouble(8), (float)args.requireDouble(9)), (float)args.requireDouble(10)), (ServerPlayer)pll.player.get());
            return null;
        });
        manager.reg("transCameraEnd", (name, args, script, o) -> {
            CogPlayer pll = (CogPlayer)o;
            CogwheelHooks.sendPacket(new CameraTransitionBound(null, null, 0.0f), (ServerPlayer)pll.player.get());
            return null;
        });
    }

    @Api.Experimental(since="2.0.0")
    public CogPlayer(@NotNull WeakReference<ServerPlayer> player) {
        super((Entity)player.get());
        this.player = player;
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name) || super.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        PropertyHandler h = MANAGER.get(name);
        if (h == null) {
            return super.getProperty(name, args, script);
        }
        return h.handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogPlayer) {
            CogPlayer other = (CogPlayer)o;
            return other.player.equals(this.player);
        }
        return false;
    }
}

