/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.testing.TestManagement;
import com.storyanvil.cogwheel.util.EasyPropManager;
import org.jetbrains.annotations.Nullable;

public class CogTestCallback
implements CGPM {
    private final TestManagement.Result testResult;
    private final TestManagement management;
    private static final EasyPropManager MANAGER = new EasyPropManager("testCallback", manager -> {
        manager.reg("assertEq", (name, args, script, o) -> {
            CGPM expected;
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (!actual.equalsTo(expected = args.get(1))) {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "EQUALS ASSERTION FAILED! \"" + actual.convertToString() + "\" != \"" + expected.convertToString() + "\""))));
            }
            return null;
        });
        manager.reg("assertNe", (name, args, script, o) -> {
            CGPM expected;
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (actual.equalsTo(expected = args.get(1))) {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "NOTEQUALS ASSERTION FAILED! \"" + actual.convertToString() + "\" == \"" + expected.convertToString() + "\""))));
            }
            return null;
        });
        manager.reg("assertNull", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (!actual.isNull()) {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "NULL ASSERTION FAILED! \"" + actual.convertToString() + "\" == \"NULL\""))));
            }
            return null;
        });
        manager.reg("assertNonNull", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (actual.isNull()) {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "NONNULL ASSERTION FAILED! \"" + actual.convertToString() + "\" != \"NULL\""))));
            }
            return null;
        });
        manager.reg("assertTrue", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (actual instanceof CogBool) {
                CogBool bool = (CogBool)actual;
                if (!bool.getValue()) {
                    callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "TRUTH ASSERTION FAILED! \"" + actual.convertToString() + "\" == FALSE"))));
                }
            } else {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "TRUTH ASSERTION FAILED! \"" + actual.convertToString() + "\" is not a CogBool"))));
            }
            return null;
        });
        manager.reg("assertFalse", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            if (actual instanceof CogBool) {
                CogBool bool = (CogBool)actual;
                if (bool.getValue()) {
                    callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "FALSE ASSERTION FAILED! \"" + actual.convertToString() + "\" == FALSE"))));
                }
            } else {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "FALSE ASSERTION FAILED! \"" + actual.convertToString() + "\" is not a CogBool"))));
            }
            return null;
        });
        manager.reg("assertJavaClass", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            CGPM actual = args.get(0);
            Class<?> clazz = actual.getClass();
            if (!clazz.getCanonicalName().equals(args.getString(1))) {
                callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "JAVACLASS ASSERTION FAILED! \"" + actual.convertToString() + "\"(" + clazz.getCanonicalName() + ") is not " + args.getString(1)))));
            }
            return null;
        });
        manager.reg("fail", (name, args, script, o) -> {
            CogTestCallback callback = (CogTestCallback)o;
            callback.testResult.failWith((Throwable)((Object)new AssertionError((Object)(CogTestCallback.line(script) + "TEST FAILED BY COGSCRIPT"))));
            return null;
        });
    });

    public CogTestCallback(TestManagement.Result testResult, TestManagement management) {
        this.testResult = testResult;
        this.management = management;
    }

    private static String line(DispatchedScript script) {
        return "[LINE:" + script.getExecutionLine() + "] ";
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        return o == this;
    }
}

