/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.env;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.infrastructure.CogScriptDispatcher;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.module.CogModule;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public final class DefaultEnvironment
extends CogScriptEnvironment {
    private final HashMap<String, Consumer<Integer>> dialogs;
    private final HashMap<ResourceLocation, CogModule> moduleMap = new HashMap();

    public DefaultEnvironment() {
        this.dialogs = new HashMap();
        CogwheelExecutor.log.info("Default Environment {} initialized!", (Object)this.getUniqueIdentifier());
    }

    @Override
    public void dispatchScript(String name) {
        CogScriptDispatcher.dispatch("cog/" + name, this);
    }

    @Override
    public void dispatchScript(String name, ScriptStorage storage) {
        CogScriptDispatcher.dispatch("cog/" + name, storage, (CogScriptEnvironment)this);
    }

    @Override
    public String getScript(String name) {
        return "cog/" + name;
    }

    @Override
    public String getUniqueIdentifier() {
        return "default_environment";
    }

    public void registerDialog(String id, Consumer<Integer> callback) {
        this.dialogs.put(id, callback);
    }

    public HashMap<String, Consumer<Integer>> getDialogs() {
        return this.dialogs;
    }

    public void putModule(ResourceLocation loc, CogModule module) {
        this.moduleMap.put(loc, module);
    }

    public CogModule getModule(ResourceLocation loc) {
        return this.moduleMap.get(loc);
    }

    public ResourceLocation getModuleLoc(CogScriptEnvironment env, String script) {
        return ResourceLocation.fromNamespaceAndPath((String)env.getUniqueIdentifier(), (String)script);
    }

    @Override
    public boolean canBeEdited() {
        return true;
    }
}

