/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.script;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.abilities.DialogTarget;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogVarLinkage;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.StreamExecutionScript;
import com.storyanvil.cogwheel.util.B;
import com.storyanvil.cogwheel.util.CogExpressionFailure;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogScript
extends StreamExecutionScript {
    private ArrayList<String> dialogsToExecute;
    private int executingLine = 0;
    private int currentLevel = 0;
    private boolean endToStart = false;
    private List<Integer> optionLines = null;

    public DialogScript(ArrayList<String> linesToExecute, ScriptStorage storage, CogScriptEnvironment environment) {
        super(storage, environment);
        this.dialogsToExecute = linesToExecute;
    }

    public DialogScript(ArrayList<String> linesToExecute, CogScriptEnvironment environment) {
        super(environment);
        this.dialogsToExecute = linesToExecute;
    }

    public void startDialog() {
        if (!Thread.currentThread().getName().contains("cogwheel-executor")) {
            RuntimeException e = new RuntimeException("Line dispatcher can only be run in cogwheel executor thread");
            e.printStackTrace();
            CogwheelExecutor.log.error("[!CRITICAL!] LINE DISPATCHER WAS CALLED FROM NON-EXECUTOR THREAD! THIS WILL CAUSE MEMORY LEAKS AND PREVENT SCRIPTS FOR PROPER EXECUTION! THIS CALL WAS DISMISSED, PROBABLY CAUSING A MEMORY LEAK!");
            throw e;
        }
        this.internalDialogStart();
    }

    private void internalDialogStart() {
        while (!this.dialogsToExecute.isEmpty()) {
            String line = this.dialogsToExecute.get(this.executingLine);
            ++this.executingLine;
            try {
                if (!this.handleLine(line)) continue;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    @Api.MixinsNotAllowed(where="DialogScript#mixinEntrypoint")
    private boolean handleLine(String line) {
        int level = 0;
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++level;
        }
        if (this.currentLevel == -1) {
            this.currentLevel = level;
        }
        if (level < this.currentLevel) {
            throw new CogExpressionFailure("Level became smaller [you can ignore this message if dialog works as intended]: " + line);
        }
        String code = line.substring(level);
        switch (code.charAt(0)) {
            case '#': {
                break;
            }
            case '+': {
                ++this.currentLevel;
                break;
            }
            case '!': {
                String l = code.substring(1);
                if (!this.addLine(l)) break;
                this.endToStart = true;
                return true;
            }
            case '/': {
                CogwheelHooks.executeCommand(code.substring(1));
                break;
            }
            case '@': {
                CGPM unchecked;
                int act = 32;
                int actPlace = -1;
                for (int i = 0; i < code.length(); ++i) {
                    char c = code.charAt(i);
                    if (c != ':' && c != '?' && c != '!') continue;
                    act = c;
                    actPlace = i;
                    break;
                }
                if ((unchecked = super.get(code.substring(1, actPlace))) instanceof DialogTarget) {
                    DialogTarget dialogTarget = (DialogTarget)((Object)unchecked);
                    if (act == 58) {
                        B<Integer> ticks = new B<Integer>();
                        String f = this.format(code.substring(actPlace + 1), ticks);
                        ticks.putIfNull(DialogScript.computeTicks(f));
                        dialogTarget.d$say(f, dialogTarget.d$name(), ticks.get(), this::startDialog);
                        return true;
                    }
                    if (act == 33) {
                        B<Integer> ticks = new B<Integer>();
                        String f = super.fastExecute(code.substring(actPlace + 1)).convertToString();
                        ticks.putIfNull(DialogScript.computeTicks(f));
                        dialogTarget.d$say(f, dialogTarget.d$name(), (Integer)ticks.get(), this::startDialog);
                        return true;
                    }
                    if (act != 63) break;
                    ArrayList<String> optionsAvailable = new ArrayList<String>();
                    this.optionLines = new ArrayList<Integer>();
                    String mask = " ".repeat(level + 1) + "+ ";
                    for (int i = this.executingLine; i < this.dialogsToExecute.size(); ++i) {
                        String L = this.dialogsToExecute.get(i);
                        if (!L.startsWith(mask)) continue;
                        this.optionLines.add(i);
                        optionsAvailable.add(this.format(L.substring(mask.length()), null));
                    }
                    dialogTarget.d$ask(this.format(code.substring(actPlace + 1), null), dialogTarget.d$name(), optionsAvailable, this::d$response);
                    return true;
                }
                throw new CogExpressionFailure("Dialog Action target is not valid: " + line);
            }
            default: {
                if (this.mixinEntrypoint(line, code, level)) break;
                throw new CogExpressionFailure("Unknown line type: " + line);
            }
        }
        return false;
    }

    @Api.MixinIntoHere
    public boolean mixinEntrypoint(String line, String code, int level) {
        return false;
    }

    public static int computeTicks(String text) {
        return Mth.clamp((int)(15 + text.split(" ").length * 10), (int)15, (int)2000);
    }

    @NotNull
    private String format(@NotNull String raw, @Nullable B<Integer> ticks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c == '$' && i + 3 < raw.length() && raw.charAt(i + 1) == '{') {
                CGPM cGPM;
                int level = 0;
                boolean quotes = false;
                StringBuilder expr = new StringBuilder();
                for (int j = i + 2; j < raw.length(); ++j) {
                    char $ = raw.charAt(j);
                    if ($ == '\"') {
                        quotes = !quotes;
                    } else if ($ == '{') {
                        ++level;
                    } else if ($ == '}' && --level < 0) {
                        i = j;
                        break;
                    }
                    expr.append($);
                }
                super.put("ticks", new CogVarLinkage("$ticks"));
                CGPM m = super.fastExecute(expr.toString());
                sb.append(m.convertToString());
                if (ticks != null && (cGPM = super.get("$ticks")) instanceof CogInteger) {
                    CogInteger t = (CogInteger)cGPM;
                    ticks.set(t.getValue());
                }
                super.put("ticks", null);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void startExecution() {
        this.startDialog();
    }

    @Override
    public void onEnd() {
        if (this.endToStart) {
            this.endToStart = false;
            this.startDialog();
        }
    }

    public void d$response(int id) {
        this.currentLevel = -1;
        this.executingLine = this.optionLines.get(id);
        this.optionLines = null;
        this.startDialog();
    }
}

