/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.testing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.config.CogwheelClientConfig;
import com.storyanvil.cogwheel.infrastructure.CogScriptDispatcher;
import com.storyanvil.cogwheel.infrastructure.cog.CogTestCallback;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.env.TestEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.CompoundException;
import com.storyanvil.cogwheel.util.DangerousRunnable;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.StoryUtils;
import com.storyanvil.cogwheel.util.WrapperException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestManagement {
    private static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/TESTS");
    private ArrayList<Result> results = new ArrayList();
    private boolean autoOnly;

    private TestManagement() {
    }

    public static void startTesting(boolean autoOnly) {
        String uuid = UUID.randomUUID().toString();
        Thread thread = new Thread(() -> TestManagement.startTestingInternal(autoOnly, uuid), "storyanvil-test-worker-" + uuid);
        thread.start();
    }

    private static void sendTestingMessage(Component msg) {
        try {
            for (ServerPlayer plr : CogwheelHooks.getOverworldServer().getServer().getPlayerList().getPlayers()) {
                plr.sendSystemMessage(msg);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void startTestingInternal(boolean autoOnly, String id) {
        File testingFolder = new File(CogwheelHooks.getConfigFolder(), "cog/tests");
        if (!CogwheelClientConfig.getTestsDirectory().isEmpty()) {
            File copyTests = new File(CogwheelClientConfig.getTestsDirectory());
            StoryUtils.deleteDirectory(testingFolder);
            testingFolder.mkdir();
            try {
                FileUtils.copyDirectory((File)copyTests, (File)testingFolder);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy testing folder", e);
            }
            TestManagement.sendTestingMessage((Component)Component.literal((String)("[CogwheelEngine] Tests copied from " + CogwheelClientConfig.getTestsDirectory())).withStyle(ChatFormatting.GRAY));
        }
        if (!testingFolder.exists()) {
            testingFolder.mkdirs();
            return;
        }
        TestManagement management = new TestManagement();
        management.autoOnly = autoOnly;
        TestManagement.sendTestingMessage((Component)Component.literal((String)"[CogwheelEngine] Testing started").withStyle(ChatFormatting.GRAY));
        StoryUtils.discoverDirectory(testingFolder, management::runTest);
        JsonArray obj = new JsonArray();
        int fails = 0;
        for (Result testResult : management.results) {
            JsonObject test = new JsonObject();
            test.addProperty("name", testResult.testName);
            test.addProperty("status", testResult.status.name());
            test.addProperty("time", testResult.timeSpend + "ms");
            if (testResult.fail != null) {
                JsonArray trace = new JsonArray();
                TestManagement.createTrace(trace, testResult.fail, "Exception in test ");
                test.add("trace", (JsonElement)trace);
            }
            if (testResult.status == Status.TEST_FAILED || testResult.status == Status.MANAGER_FAILED) {
                ++fails;
            }
            obj.add((JsonElement)test);
        }
        JsonObject report = new JsonObject();
        report.addProperty("failedTests", (Number)fails);
        report.addProperty("date", new Date().toString());
        report.addProperty("id", id);
        report.add("results", (JsonElement)obj);
        if (fails == 0) {
            TestManagement.sendTestingMessage((Component)Component.literal((String)"[CogwheelEngine] Testing finished. ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"All tests were successful!").withStyle(ChatFormatting.GREEN)));
        } else {
            TestManagement.sendTestingMessage((Component)Component.literal((String)"[CogwheelEngine] Testing finished. ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(fails + " tests failed!")).withStyle(ChatFormatting.RED)));
        }
        try (FileWriter fw = new FileWriter(new File(testingFolder, "results.json"));){
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setStrictness(Strictness.LENIENT);
            jsonWriter.setIndent("    ");
            Streams.write((JsonElement)report, (JsonWriter)jsonWriter);
            fw.write(stringWriter.toString());
            fw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createTrace(@NotNull JsonArray array, @Nullable Throwable t, @NotNull String msg) {
        if (t == null) {
            return;
        }
        array.add(msg + t.getClass().getCanonicalName() + ": " + t.getMessage() + (String)(t.getLocalizedMessage() == null || t.getLocalizedMessage().equals(t.getMessage()) ? "[NO LOCALIZED MSG]" : " [" + t.getLocalizedMessage() + "]"));
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            array.add(" at " + stackTraceElement.toString());
        }
        for (Serializable serializable : t.getSuppressed()) {
            JsonArray supr = new JsonArray();
            TestManagement.createTrace(supr, (Throwable)serializable, "Suppressed ");
            array.add((JsonElement)supr);
        }
        if (t.getCause() != null) {
            JsonArray cause = new JsonArray();
            TestManagement.createTrace(cause, t.getCause(), "Caused by ");
            array.add((JsonElement)cause);
        }
    }

    public void runTest(File file, String path) {
        if (file.getName().equals("results.json")) {
            return;
        }
        if (!file.getName().endsWith(".json")) {
            return;
        }
        long timeStarted = System.currentTimeMillis();
        Result result = new Result(path.substring(0, path.lastIndexOf(46)));
        this.results.add(result);
        try (FileReader fr = new FileReader(file);){
            JsonObject obj = JsonParser.parseReader((Reader)fr).getAsJsonObject();
            if (obj.has("auto") && !obj.get("auto").getAsBoolean() && this.autoOnly) {
                result.setStatus(Status.SKIPPED);
                result.setFail(new Exception("Test is marked as NON-AUTO, but current testing context only allows AUTO tests"));
                return;
            }
            TestType type = TestType.valueOf(obj.get("type").getAsString());
            try {
                type.handler.handle(result, obj, this);
            }
            catch (Throwable e) {
                result.failWith(e);
                log.error("Test {} failed with exception", (Object)result.testName, (Object)result.fail);
            }
            if (result.fail != null) {
                result.status = Status.TEST_FAILED;
            }
        }
        catch (JsonIOException | JsonSyntaxException | IOException | IllegalArgumentException | IllegalStateException e) {
            result.failWith(e);
            result.setStatus(Status.MANAGER_FAILED);
        }
        result.timeSpend = System.currentTimeMillis() - timeStarted;
        TestManagement.sendTestingMessage((Component)Component.literal((String)("[CogwheelEngine] " + result.testName + " -> ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)result.status.name()).withStyle(result.status.formatting)));
    }

    public static class Result {
        private final String testName;
        private Status status = Status.IN_PROGRESS;
        private Throwable fail = null;
        private long timeSpend = -1L;

        public Result(String testName) {
            this.testName = testName;
        }

        public String getTestName() {
            return this.testName;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Throwable getFail() {
            return this.fail;
        }

        public void setFail(Throwable fail) {
            this.fail = fail;
        }

        public void failWith(Throwable fail) {
            if (this.fail == null) {
                this.fail = fail;
            } else {
                Throwable throwable = this.fail;
                if (throwable instanceof CompoundException) {
                    CompoundException compound = (CompoundException)throwable;
                    compound.addUniqueException(fail);
                } else {
                    CompoundException ce = new CompoundException(this.fail);
                    this.fail = ce;
                    ce.addUniqueException(fail);
                }
            }
            this.status = Status.TEST_FAILED;
        }

        public boolean failIf(boolean shouldFail, Supplier<Throwable> failure) throws Throwable {
            if (shouldFail) {
                Throwable t = failure.get();
                this.failWith(t);
                throw t;
            }
            return false;
        }

        public boolean failIf(boolean shouldFail, String msg) throws Throwable {
            return this.failIf(shouldFail, () -> new RuntimeException(msg));
        }

        public <T> T failIfNull(T check, Supplier<Throwable> failure) throws Throwable {
            if (check == null) {
                Throwable t = failure.get();
                this.failWith(t);
                throw t;
            }
            return check;
        }

        public <T> T failIfNull(T check, String msg) throws Throwable {
            return this.failIfNull(check, () -> new RuntimeException(msg));
        }

        public boolean failIfNot(boolean shouldNotFail, Supplier<Throwable> failure) throws Throwable {
            if (!shouldNotFail) {
                Throwable t = failure.get();
                this.failWith(t);
                throw t;
            }
            return true;
        }

        public boolean failIfNot(boolean shouldNotFail, String msg) throws Throwable {
            return this.failIfNot(shouldNotFail, () -> new RuntimeException(msg));
        }

        public void executeSafely(DangerousRunnable r) {
            try {
                r.run();
            }
            catch (Throwable e) {
                this.failWith(e);
            }
        }

        public void executeSafely(DangerousRunnable r, String failMsg) {
            try {
                r.run();
            }
            catch (Throwable e) {
                this.failWith(new WrapperException(failMsg, e));
            }
        }
    }

    public static enum Status {
        IN_PROGRESS(ChatFormatting.GOLD),
        TEST_FAILED(ChatFormatting.RED),
        MANAGER_FAILED(ChatFormatting.RED),
        OK(ChatFormatting.GREEN),
        SKIPPED(ChatFormatting.DARK_GRAY);

        public final ChatFormatting formatting;

        private Status(ChatFormatting formatting) {
            this.formatting = formatting;
        }
    }

    public static enum TestType {
        OK((result, manifest, management) -> result.setStatus(Status.OK)),
        FAIL((result, manifest, management) -> {
            throw new RuntimeException("Always fails.");
        }),
        SCRIPT((result, manifest, management) -> {
            CountDownLatch threadLock = new CountDownLatch(1);
            TestEnvironment environment = new TestEnvironment();
            CogTestCallback callback = new CogTestCallback(result, management);
            DispatchedScript script = CogScriptDispatcher.dispatchUnsafe(environment.getScript(manifest.getAsJsonPrimitive("scriptName").getAsString()), new ScriptStorage().append("TEST", callback), (CogScriptEnvironment)environment, false);
            if (script == null) {
                throw new AssertionError((Object)"No script were found!");
            }
            CogwheelExecutor.schedule(() -> {
                script.setOnEnd(threadLock::countDown);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                script.lineDispatcher();
            });
            boolean executed = threadLock.await(5000L, TimeUnit.MILLISECONDS);
            if (!executed) {
                script.haltExecution();
                environment.dispose();
                throw new AssertionError((Object)"Script execution timeout reached. Script took longer than 5000ms and was terminated");
            }
            result.setStatus(Status.OK);
            script.haltExecution();
            environment.dispose();
        }),
        COGSCRIPT_DOCS((result, manifest, management) -> {
            throw new WrapperException("COGSCRIPT_DOCS test type is not allowed.");
        }),
        SCRIPT_READER((result, manifest, management) -> {
            TestEnvironment environment = new TestEnvironment();
            DispatchedScript script = CogScriptDispatcher.dispatchUnsafe(environment.getScript(manifest.getAsJsonPrimitive("scriptName").getAsString()), new ScriptStorage(), (CogScriptEnvironment)environment, false);
            if (script == null) {
                throw new WrapperException("No scripts were found!");
            }
            String entireScript = String.join((CharSequence)"\\n", script.getAllLines());
            if (!entireScript.equals(manifest.getAsJsonPrimitive("expectedScript").getAsString())) {
                log.warn("Test {}: script had text \"{}\"", (Object)result.testName, (Object)entireScript);
                throw new WrapperException("Script does not match expected script.");
            }
            result.setStatus(Status.OK);
        });

        public final TestTypeHandler handler;

        private TestType(TestTypeHandler handler) {
            this.handler = handler;
        }
    }

    public static interface TestTypeHandler {
        public void handle(Result var1, JsonObject var2, TestManagement var3) throws Exception;
    }
}

