/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.items;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.network.devui.inspector.InspectableBlock;
import com.storyanvil.cogwheel.network.devui.inspector.InspectableEntity;
import com.storyanvil.cogwheel.network.mc.Notification;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class InspectorItem
extends Item {
    public InspectorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (!ctx.getLevel().isClientSide) {
            BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
            ServerLevel level = (ServerLevel)ctx.getLevel();
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            Block block = state.getBlock();
            if (block instanceof InspectableBlock) {
                InspectableBlock ib = (InspectableBlock)block;
                if (InspectorItem.devEnvCheck(player)) {
                    if (player == null) {
                        return super.useOn(ctx);
                    }
                    if (ib.tryToInspect(level, player, state, ctx)) {
                        return InteractionResult.CONSUME;
                    }
                }
            }
        }
        return super.useOn(ctx);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player _player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (_player instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)_player;
            if (stack.is(CogwheelHooks.getInspectorItem()) && target instanceof InspectableEntity) {
                InspectableEntity ie = (InspectableEntity)target;
                if (InspectorItem.devEnvCheck(player) && ie.tryToInspect(player.serverLevel(), player)) {
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.interactLivingEntity(stack, _player, target, hand);
    }

    private static boolean devEnvCheck(ServerPlayer plr) {
        if (CogwheelConfig.isDevEnvironment()) {
            return true;
        }
        CogwheelHooks.sendPacket(new Notification((Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_ban"), (Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_ban_msg")), plr);
        return false;
    }
}

