/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.mixin;

import com.storyanvil.cogwheel.client.CutSceneManagement;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.util.Bi;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    private boolean detached;

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract void setPosition(Vec3 var1);

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Shadow
    public abstract Vec3 getPosition();

    @Shadow
    public abstract float getYRot();

    @Shadow
    public abstract float getXRot();

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="RETURN")})
    public void update(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        try {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            boolean detach = false;
            CameraPos force = CutSceneManagement.getPositionForce();
            if (force != null) {
                this.setPosition(force.getPos());
                this.setRotation(force.getRotY(), force.getRotX());
                detach = true;
                return;
            }
            Bi<CameraPos, CameraPos> transition = CutSceneManagement.getTransition();
            if (transition != null) {
                boolean upd = false;
                if (transition.getA() == null) {
                    transition.setA(new CameraPos(this.getPosition(), this.getYRot(), this.getXRot()));
                    upd = true;
                }
                if (transition.getB() == null) {
                    transition.setB(new CameraPos(this.getPosition(), this.getYRot(), this.getXRot()));
                    upd = true;
                }
                if (upd) {
                    CutSceneManagement.setTransition(transition);
                }
                float delta = CutSceneManagement.getTransitionDelta() + tickDelta;
                CutSceneManagement.setTransitionDelta(delta);
                float progress = Mth.clamp((float)((delta + 0.01f) / CutSceneManagement.getTransitionGoal()), (float)0.0f, (float)1.0f);
                Vec3 A = transition.getA().getPos();
                Vec3 B2 = transition.getB().getPos();
                this.setPosition(Mth.lerp((double)progress, (double)A.x, (double)B2.x), Mth.lerp((double)progress, (double)A.y, (double)B2.y), Mth.lerp((double)progress, (double)A.z, (double)B2.z));
                this.setRotation(Mth.rotLerp((float)progress, (float)transition.getA().getRotY(), (float)transition.getB().getRotY()), Mth.rotLerp((float)progress, (float)transition.getA().getRotX(), (float)transition.getB().getRotX()));
                detach = true;
            }
            this.detached |= detach;
            CutSceneManagement.setRenderHand(!detach);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

