/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.neoforge;

import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.entity.NPC;
import com.storyanvil.cogwheel.neoforge.NeoRegistry;
import com.storyanvil.cogwheel.neoforge.client.NPCRenderer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="storyanvil_cogwheel")
public final class CogwheelEngineNeoForge {
    public static final Logger PLATFORM_LOG = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/NEOFORGE");

    public CogwheelEngineNeoForge(IEventBus bus, ModContainer container) {
        CogwheelEngine.init();
        NeoRegistry.ATTACHMENT_TYPES.register(bus);
        NeoRegistry.ENTITIES.register(bus);
        NeoRegistry.ITEMS.register(bus);
    }

    @EventBusSubscriber(modid="storyanvil_cogwheel")
    public static class ModEvents {
        @SubscribeEvent
        public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put(NeoRegistry.NPC.get(), NPC.createAttributes().build());
        }
    }

    @EventBusSubscriber(modid="storyanvil_cogwheel", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(NeoRegistry.NPC.get(), NPCRenderer::new);
        }

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)NeoRegistry.OPEN_DEVUI.get());
        }
    }
}

