/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.neoforge;

import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.neoforge.CogwheelEngineNeoForge;
import com.storyanvil.cogwheel.neoforge.NeoRegistry;
import com.storyanvil.cogwheel.neoforge.client.NPCModel;
import com.storyanvil.cogwheel.neoforge.data.StoryNeoParcel;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.IModInfo;

public class CogwheelHooksImpl {
    public static byte performVersionCheck() {
        Optional container = ModList.get().getModContainerById("storyanvil_cogwheel");
        if (container.isEmpty()) {
            return 0;
        }
        switch (VersionChecker.getResult((IModInfo)((ModContainer)container.get()).getModInfo()).status()) {
            case UP_TO_DATE: 
            case BETA: {
                return 1;
            }
            case OUTDATED: 
            case BETA_OUTDATED: {
                return 2;
            }
        }
        return 0;
    }

    public static CGPM getLevelData(String key) {
        throw new AssertionError();
    }

    public static void putLevelData(String key, CogPrimalType value) {
        throw new AssertionError();
    }

    public static File getConfigFolder() {
        try {
            return new File(Minecraft.getInstance().gameDirectory.getCanonicalFile(), "config");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends StoryPacket<T>> void sendPacket(StoryPacket<T> packet, ServerPlayer plr) {
        PacketDistributor.sendToPlayer((ServerPlayer)plr, new StoryNeoParcel<T>(packet.getAsData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends StoryPacket<T>> void sendPacketToServer(StoryPacket<T> packet) {
        PacketDistributor.sendToServer(new StoryNeoParcel<T>(packet.getAsData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends StoryPacket<T>> void sendPacketToEveryone(StoryPacket<T> packet) {
        PacketDistributor.sendToAllPlayers(new StoryNeoParcel<T>(packet.getAsData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static KeyMapping getDevUIBind() {
        return (KeyMapping)NeoRegistry.OPEN_DEVUI.get();
    }

    public static Item getInspectorItem() {
        return NeoRegistry.INSPECTOR.get();
    }

    public static void setAnimationData(ResourceLocation[] locations) {
        NPCModel.animationSources = locations;
    }

    public static void startupMessage(String message) {
        StartupNotificationManager.addModMessage((String)message);
        CogwheelEngineNeoForge.PLATFORM_LOG.info("STARTUP - {}", (Object)message);
    }
}

