/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.neoforge.CogwheelEngineNeoForge;
import com.storyanvil.cogwheel.neoforge.data.StoryNeoPacket;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import com.storyanvil.cogwheel.network.mc.AnimationDataBound;
import com.storyanvil.cogwheel.util.Bi;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="storyanvil_cogwheel")
public class NeoForgeEventBus {
    @SubscribeEvent
    public static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        final PayloadRegistrar reg = event.registrar("Cog3");
        CogwheelHooks.packetRegistry(new CogwheelHooks.PacketRegistrar(){

            @Override
            public <T extends StoryPacket<T>> void accept(String id, StoryCodec<T> codec, Class<T> clazz) {
                id = id.toLowerCase(Locale.ENGLISH);
                StoryNeoPacket<T> neoPacket = new StoryNeoPacket<T>(id, codec);
                CogwheelEngineNeoForge.PLATFORM_LOG.debug("Registered packet {} with [id={},class={}]", new Object[]{neoPacket, id, clazz});
                reg.playBidirectional(neoPacket.getType().type(), neoPacket, (IPayloadHandler)new DirectionalPayloadHandler(neoPacket::clientHandle, neoPacket::serverHandle));
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CogwheelHooks.commandRegistry(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        if (!((ResourceKey)event.getLevel().dimensionTypeRegistration().unwrapKey().get()).location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld"))) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            List<Bi<Consumer<ClientLevel>, Integer>> list = EventBus.clientQueue;
            synchronized (list) {
                try {
                    for (int i = 0; i < EventBus.clientQueue.size(); ++i) {
                        Bi<Consumer<ClientLevel>, Integer> e = EventBus.clientQueue.get(i);
                        if (e.getB() < 2) {
                            e.getA().accept((ClientLevel)event.getLevel());
                            EventBus.clientQueue.remove(i);
                            --i;
                            continue;
                        }
                        e.setB(e.getB() - 1);
                    }
                }
                catch (Exception e) {
                    CogwheelEngine.LOGGER.warn("Client Queue bound error", (Throwable)e);
                }
                return;
            }
        }
        List<Bi<Consumer<ServerLevel>, Integer>> list = EventBus.queue;
        synchronized (list) {
            try {
                for (int i = 0; i < EventBus.queue.size(); ++i) {
                    Bi<Consumer<ServerLevel>, Integer> e = EventBus.queue.get(i);
                    if (e.getB() < 2) {
                        try {
                            e.getA().accept((ServerLevel)event.getLevel());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        EventBus.queue.remove(i);
                        --i;
                        continue;
                    }
                    e.setB(e.getB() - 1);
                }
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("Queue bound error", (Throwable)e);
            }
            try {
                EventBus.getStoryLevel().tick((ServerLevel)event.getLevel());
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("StoryLevel tick error", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void boundEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StringBuilder sb = new StringBuilder();
            boolean a = true;
            for (ResourceLocation loc : EventBus.serverSideAnimations) {
                if (a) {
                    a = false;
                } else {
                    sb.append("|");
                }
                sb.append(loc.toString());
            }
            CogwheelHooks.sendPacket(new AnimationDataBound(sb.toString()), player2);
            DevEarlySyncPacket.syncFor(player2, true);
            DevEditorSession.boundColorFor(player2);
        }
    }

    @SubscribeEvent
    public static void unboundEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DevEditorSession.unboundColorFrom(player2);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CogwheelHooks.serverStart();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        CogwheelHooks.serverStop();
    }
}

