/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.neoforge.data;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.neoforge.CogwheelEngineNeoForge;
import com.storyanvil.cogwheel.neoforge.data.StoryNeoPacketContext;
import com.storyanvil.cogwheel.neoforge.data.StoryNeoParcel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class StoryNeoPacket<T extends StoryPacket<T>>
implements StreamCodec<FriendlyByteBuf, StoryNeoParcel<T>> {
    private final StoryCodec<T> parent;
    private final CustomPacketPayload.TypeAndCodec<FriendlyByteBuf, StoryNeoParcel<T>> type;

    public StoryNeoPacket(@NotNull String id, @NotNull StoryCodec<T> parent) {
        this.parent = parent;
        this.type = new CustomPacketPayload.TypeAndCodec(new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)id)), (StreamCodec)this);
        parent.setPlatformData(this);
    }

    public StoryNeoParcel<T> decode(FriendlyByteBuf buf) {
        return new StoryNeoParcel<StoryPacket>((StoryPacket)this.parent.decode(buf));
    }

    public void encode(FriendlyByteBuf buf, StoryNeoParcel<T> value) {
        this.parent.encode((StoryPacket)value.get(), buf);
    }

    public CustomPacketPayload.TypeAndCodec<FriendlyByteBuf, StoryNeoParcel<T>> getType() {
        return this.type;
    }

    public <S extends StoryPacket<S>> void clientHandle(StoryNeoParcel<S> parcel, IPayloadContext ctx) {
        CogwheelExecutor.schedule(() -> {
            CogwheelHooks.debugLog(CogwheelEngineNeoForge.PLATFORM_LOG, "Received packet {} from server", (Object)parcel);
            ((StoryPacket)parcel.get()).onClientUnsafe(new StoryNeoPacketContext(ctx));
        });
    }

    public <S extends StoryPacket<S>> void serverHandle(StoryNeoParcel<S> parcel, IPayloadContext ctx) {
        CogwheelExecutor.schedule(() -> {
            CogwheelHooks.debugLog(CogwheelEngineNeoForge.PLATFORM_LOG, "Received packet {} from client: {}", parcel, ctx.player());
            ((StoryPacket)parcel.get()).onServerUnsafe(new StoryNeoPacketContext(ctx));
        });
    }

    public String toString() {
        return "StoryNeoPacket{parent=" + String.valueOf(this.parent) + ", type=" + String.valueOf(this.type) + "}";
    }
}

