/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.client.devui.DevUIScreen;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.data.IStoryPacketContext;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBldr;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public record DevEarlySyncPacket(boolean permitted, boolean silent) implements StoryPacket<DevEarlySyncPacket>
{
    public static final StoryCodec<DevEarlySyncPacket> CODEC = StoryCodecBldr.build(StoryCodecBldr.Bool(DevEarlySyncPacket::permitted), StoryCodecBldr.Bool(DevEarlySyncPacket::silent), DevEarlySyncPacket::new);

    @Override
    public StoryCodec<DevEarlySyncPacket> getStoryCodec() {
        return CODEC;
    }

    public static void syncFor(ServerPlayer player, boolean silent) {
        CogwheelNetwork.sendFromServer(player, new DevEarlySyncPacket(DevEarlySyncPacket.isDev(), silent));
    }

    public static boolean isDev() {
        return CogwheelConfig.isDevEnvironment();
    }

    @Override
    public void onServerUnsafe(IStoryPacketContext ctx) {
        DevEarlySyncPacket.syncFor(ctx.getSender(), this.silent);
    }

    @Override
    public void onClientUnsafe(IStoryPacketContext ctx) {
        DevUI.permitted = this.permitted;
        if (!this.permitted) {
            CogwheelExecutor.scheduleTickEventClientSide(levelTickEvent -> {
                if (Minecraft.getInstance().screen instanceof DevUIScreen) {
                    Minecraft.getInstance().setScreen(null);
                    Minecraft.getInstance().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_block"), (Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_block_msg")));
                }
            });
        }
        if (!this.silent) {
            Minecraft.getInstance().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_block"), (Component)Component.translatable((String)"ui.storyanvil_cogwheel.notif_block_msg")));
        }
    }
}

