/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.data.IStoryPacketContext;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBldr;
import com.storyanvil.cogwheel.data.StoryCodecs;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import net.minecraft.resources.ResourceLocation;

public record DevEditorState(ResourceLocation lc, Byte state) implements StoryPacket<DevEditorState>
{
    public static final StoryCodec<DevEditorState> CODEC = StoryCodecBldr.build(StoryCodecBldr.Prop(DevEditorState::lc, StoryCodecs.RESOURCE_LOC), StoryCodecBldr.Byte(DevEditorState::state), DevEditorState::new);

    @Override
    public StoryCodec<DevEditorState> getStoryCodec() {
        return CODEC;
    }

    @Override
    public void onServerUnsafe(IStoryPacketContext ctx) {
        DevEditorSession session = DevEditorSession.get(this.lc);
        if (session == null) {
            this.error(ctx, "Invalid session!");
            return;
        }
        if (this.state == -128) {
            session.closeConnection(ctx.getSender());
            return;
        }
        if (this.state == -127) {
            session.resync(ctx.getSender());
            return;
        }
    }

    @Override
    public void onClientUnsafe(IStoryPacketContext ctx) {
        if (this.state == -128) {
            DWCodeEditor editor = DWCodeEditor.get(this.lc);
            if (editor == null) {
                return;
            }
            DWCodeEditor.delete(this.lc);
            this.clientError(ctx, "Server closed your edition session!");
        }
    }
}

